#pragma once

#include <drive/backend/doc_packages/template.h>

class TYandexDiskClient;

enum class EDiskOutput {
    RentTermsDate /* "rent_terms_date" */,
    RentTermsDateHr /* "rent_terms_date_hr" */,
    ServiceUsingTermsDate /* "service_using_terms_date" */,
    ServiceUsingTermsDateHr /* "service_using_terms_date_hr" */,
    RentCertifiedTermsDate /* "rent_сertified_terms_date" */,
    ServiceUsingCertifiedTermsDate /* "service_using_certified_terms_date" */,
    Undefined /* "undefined" */,
};

class TDiskTemplate : public ITemplateDataByStorage<EDiskOutput> {
public:
    enum EInput {
        Date /* "disk_current_date" */,
    };

public:
    virtual bool Fetch(const NJson::TJsonValue& json, const NDrive::IServer& server, TMessagesCollector& errors) override;
    bool Fetch(const TInstant date, const NDrive::IServer& server, TMessagesCollector& errors);

    virtual const TString& GetName() const override {
        return Name;
    }

    virtual TVector<TString> GetInputs() const override {
        TVector<TString> result;
        for (auto&& var : GetEnumAllValues<EInput>()) {
            result.push_back(ToString(var));
        }
        return result;
    }

    virtual void AddInputsToScheme(const IServerBase& server, NDrive::TScheme& scheme) const override;

private:
    bool FindActualDocument(const TInstant date, const TString& path, EDiskOutput value, const TYandexDiskClient& client, TMessagesCollector& errors, EDiskOutput hrValue = EDiskOutput::Undefined, bool addHrValue = false);

private:
    static TSet<EOutput> DateParameters;
    static TString Name;
    static TFactory::TRegistrator<TDiskTemplate> Registrator;
};
