#include "document.h"

#include <drive/backend/database/drive_api.h>
#include <library/cpp/string_utils/relaxed_escaper/relaxed_escaper.h>

TDocumentDescription::TFactory::TRegistrator<TRawDocument> TRawDocument::Registrator("raw");

bool TRawDocument::DoParseMeta(const NJson::TJsonValue& meta) {
    Content = meta["content"].GetStringRobust();
    return true;
}

NJson::TJsonValue TRawDocument::DoSaveMeta() const {
    NJson::TJsonValue meta;
    meta["content"] = Content;
    return meta;
}

bool TRawDocument::DoCreateContent(const NJson::TJsonValue& /*postData*/,
                                 const TMap<TString, ITemplateData::TPtr>& parameters,
                                 const NDrive::IServer& /*server*/,
                                 IDocumentAssembler& builder,
                                 TMessagesCollector& errors) const {
    TString content = Content;
    for (auto&& p : parameters) {
        p.second->Substitude(content, GetDataEscape());
    }
    if (GetDocumentFormat() == "json_string") {
        content = NEscJ::EscapeJ<false>(content);
    }
    return builder.AddBlock(content, errors);
}

NDrive::TScheme TRawDocument::DoGetScheme(const IServerBase& /*server*/) const {
    NDrive::TScheme result;
    result.Add<TFSString>("content").SetRequired(true);
    return result;
}
