#pragma once

#include <drive/backend/doc_packages/document.h>

class TRawDocument: public TDocumentDescription {
    R_READONLY(TString, Content);
public:
    virtual bool DoParseMeta(const NJson::TJsonValue& meta) override;
    virtual NJson::TJsonValue DoSaveMeta() const override;

    virtual bool DoCreateContent(const NJson::TJsonValue& /*postData*/,
                               const TMap<TString, ITemplateData::TPtr>& parameters,
                               const NDrive::IServer& /*server*/,
                               IDocumentAssembler& builder,
                               TMessagesCollector& /*errors*/) const override;

    virtual NDrive::TScheme DoGetScheme(const IServerBase& /*server*/) const override;

private:
    static TFactory::TRegistrator<TRawDocument> Registrator;
};
