#pragma once

#include <drive/backend/doc_packages/document.h>

#include <drive/library/cpp/image_transformation/transformation.h>

class IExternalDocument : public TDocumentDescription {
    using TBase = TDocumentDescription;
private:
    R_READONLY(TString, Path);
    R_READONLY(TString, Storage);

public:
    virtual bool DoParseMeta(const NJson::TJsonValue& meta) override;
    virtual NJson::TJsonValue DoSaveMeta() const override;

    virtual bool DoCreateContent(const NJson::TJsonValue& postData,
                               const TMap<TString, ITemplateData::TPtr>& parameters,
                               const NDrive::IServer& server,
                               IDocumentAssembler& builder,
                               TMessagesCollector& errors) const override;

    virtual NDrive::TScheme DoGetScheme(const IServerBase& /*server*/) const override;
    virtual void AddPostParametersToScheme(NDrive::TScheme& scheme, const IServerBase& server) const override;

private:
    virtual EBlockType GetBlockType() const = 0;

    virtual bool ApplyTransformation(TString& /*context*/, const TMap<TString, ITemplateData::TPtr>& /*parameters*/, const NDrive::IServer& /*server*/, IDocumentAssembler& /*builder*/, TMessagesCollector& /*errors*/) const {
        return true;
    }

    virtual TAddBlockContext GetBlockContext() const {
        return TAddBlockContext();
    }
};

class TImageDocument : public IExternalDocument {
    R_READONLY(NImageTransformation::TTransformationConfig, TransformationConfig);
    R_READONLY(TAddBlockContext, AddBlockContext);
private:
    virtual bool DoParseMeta(const NJson::TJsonValue& meta) override;
    virtual NJson::TJsonValue DoSaveMeta() const override;
    virtual NDrive::TScheme DoGetScheme(const IServerBase& /*server*/) const override;

    virtual EBlockType GetBlockType() const override {
        return EBlockType::Image;
    };

    virtual TAddBlockContext GetBlockContext() const override {
        return AddBlockContext;
    }

    virtual bool ApplyTransformation(TString& context, const TMap<TString, ITemplateData::TPtr>& parameters, const NDrive::IServer& server, IDocumentAssembler& builder, TMessagesCollector& errors) const override;

private:
    static TFactory::TRegistrator<TImageDocument> Registrator;
};

class TBinaryDocument : public IExternalDocument {
private:
    virtual EBlockType GetBlockType() const override {
        return EBlockType::Binary;
    };
    static TFactory::TRegistrator<TBinaryDocument> Registrator;
};

class TTextDocument : public IExternalDocument {
private:
    virtual EBlockType GetBlockType() const override {
        return EBlockType::Text;
    };
    static TFactory::TRegistrator<TTextDocument> Registrator;

    virtual bool ApplyTransformation(TString& context, const TMap<TString, ITemplateData::TPtr>& parameters, const NDrive::IServer& server, IDocumentAssembler& /*builder*/, TMessagesCollector& errors) const override;
};

class TPdfDocument : public IExternalDocument {
private:
    virtual EBlockType GetBlockType() const override {
        return EBlockType::Pdf;
    };
    static TFactory::TRegistrator<TPdfDocument> Registrator;
};
