#pragma once

#include <drive/backend/doc_packages/document.h>

class TDocumentsPackage: public TDocumentDescription {
    R_READONLY(TVector<TString>, Documents, {});
public:
    virtual bool DoParseMeta(const NJson::TJsonValue& meta) override;
    virtual NJson::TJsonValue DoSaveMeta() const override;

    virtual bool DoCreateContent(const NJson::TJsonValue& postData,
                               const TMap<TString, ITemplateData::TPtr>& parameters,
                               const NDrive::IServer& server,
                               IDocumentAssembler& builder,
                               TMessagesCollector& errors) const override;

    virtual NDrive::TScheme DoGetScheme(const IServerBase& server) const override;
    virtual void AddTemplatesToScheme(NDrive::TScheme& scheme, const IServerBase& server) const override;
    virtual void AddPostParametersToScheme(NDrive::TScheme& scheme, const IServerBase& server) const override;
    virtual bool AddTemplatesFromPostData(TMap<TString, ITemplateData::TPtr>& result, const NJson::TJsonValue& json, const NDrive::IServer& server, TMessagesCollector& errors) const override;

private:
    static TFactory::TRegistrator<TDocumentsPackage> Registrator;
};
