#pragma once

#include "session_templates.h"

enum class EFineInput {
    FineId /* "fine_id" */,
};

enum class EFineOutput {
    RulingNumber /* "ruling_number" */,
    RulingDate /* "ruling_date" */,
    ViolationDate /* "violation_date" */,
    ViolationPlace /* "violation_place" */,
    ArticleKoap /* "article_koap" */,
    ArticleCode /* "article_code" */,
};

class TFineTemplate: public ITemplateDataByStorage<EFineOutput> {
public:
    using EInput = EFineInput;

public:
    virtual const TString& GetName() const override;
    virtual TVector<TString> GetInputs() const override;
    virtual void AddInputsToScheme(const IServerBase& /* server */, NDrive::TScheme& scheme) const override;
    virtual bool Fetch(const NJson::TJsonValue& json, const NDrive::IServer& server, TMessagesCollector& errors) override;
    virtual void FetchOverride(const NJson::TJsonValue& json) override;
    virtual void Substitude(TString& inputData, const TDataEscape escape) const override;

private:
    TSessionTemplate SessionTemplate;

private:
    static TString Name;
    static TFactory::TRegistrator<TFineTemplate> Registrator;
};
