#include "payment_template.h"

#include <drive/backend/abstract/frontend.h>

using namespace NTemplateData;

TString TPaymentTemplate::Name("payment");
TSet<TPaymentTemplate::EOutput> TPaymentTemplate::TimeParameters = { TPaymentTemplate::EOutput::LastUpdate, TPaymentTemplate::EOutput::CreatedAt };
TSet<TPaymentTemplate::EOutput> TPaymentTemplate::MoneyParameters = { TPaymentTemplate::EOutput::Sum, TPaymentTemplate::EOutput::Cleared };
ITemplateData::TFactory::TRegistrator<TPaymentTemplate> TPaymentTemplate::Registrator(TPaymentTemplate::Name);

void TPaymentTemplate::AddParameter(TPaymentTemplate::EOutput parameter, const NJson::TJsonValue& json) {
    THRTime time;
    if (TimeParameters.contains(parameter) && IHRInstant::TryFromString(json.GetStringRobust(), time)) {
        Storage.AddParameter(parameter, time.ToString());
    } else if (MoneyParameters.contains(parameter)) {
        Storage.AddParameter(parameter, ::ToString(json.GetDoubleRobust() / 100) + " rub");
    } else {
        Storage.AddParameter(parameter, json.GetStringRobust());
    }
}

bool TPaymentTemplate::Fetch(const NJson::TJsonValue& json, const NDrive::IServer& /*server*/, TMessagesCollector& /*errors*/) {
    for (const auto& parameter : Storage.GetEnumOutputs()) {
        const NJson::TJsonValue* value = json["payment"].GetValueByPath(ToString(parameter));
        if (value) {
            AddParameter(parameter, *value);
        }
    }
    return true;
}

TString TRefundTemplate::Name("refund");
TSet<TRefundTemplate::EOutput> TRefundTemplate::MoneyParameters = { TRefundTemplate::EOutput::Bill, TRefundTemplate::EOutput::PromocodeSum };
TSet<TRefundTemplate::EOutput> TRefundTemplate::TimeParameters = { TRefundTemplate::EOutput::Time };
ITemplateData::TFactory::TRegistrator<TRefundTemplate> TRefundTemplate::Registrator(TRefundTemplate::Name);

void TRefundTemplate::AddParameter(TRefundTemplate::EOutput parameter, const NJson::TJsonValue& json, const NDrive::IServer& server) {
    THRTime time;
    if (MoneyParameters.contains(parameter)) {
        Storage.AddParameter(parameter, server.GetLocalization()->FormatPrice(ELocalization::Rus, json.GetUIntegerRobust()));
    } else if (TimeParameters.contains(parameter) && IHRInstant::TryFromString(json.GetStringRobust(), time)) {
        Storage.AddParameter(parameter, time.ToString());
    } else {
        Storage.AddParameter(parameter, json.GetStringRobust());
    }
}

bool TRefundTemplate::Fetch(const NJson::TJsonValue& json, const NDrive::IServer& server, TMessagesCollector& /*errors*/) {
    for (const auto& parameter : Storage.GetEnumOutputs()) {
        const NJson::TJsonValue* value = json["refund"].GetValueByPath(ToString(parameter));
        if (value) {
            AddParameter(parameter, *value, server);
        }
    }
    if (Storage.GetParameter(EOutput::Bill)) {
        Storage.AddParameter(EOutput::BillHR, Storage.GetParameter(EOutput::Bill) + " руб");
    }
    if (Storage.GetParameter(EOutput::PromocodeSum)) {
        Storage.AddParameter(EOutput::PromocodeSumHR, Storage.GetParameter(EOutput::PromocodeSum) + " руб");
    }
    return true;
}
