#pragma once

#include <drive/backend/doc_packages/template.h>

enum class EPaymentOutput {
    Id /* "id" */,
    AccountId /* "account_id" */,
    PayMethod /* "pay_method" */,
    PaymentId /* "payment_id" */,
    SessionId /* "session_id" */,
    RRN /* "rrn" */,
    CardMask /* "card_mask" */,
    PaymentError /* "payment_error" */,
    PaymentErrorDescription /* "payment_error_desc" */,
    OrderId /* "order_id" */,
    PaymentType /* "payment_type" */,
    BillingType /* "billing_type" */,
    Status /* "status" */,
    Sum /* "sum" */,
    Cleared /* "cleared" */,
    LastUpdate /* "last_update_ts" */,
    CreatedAt /* "created_at_ts" */,
    UserId /* "user_id" */,
};

class TPaymentTemplate: public ITemplateDataByStorage<EPaymentOutput> {
public:
    virtual bool Fetch(const NJson::TJsonValue& json, const NDrive::IServer& server, TMessagesCollector& errors) override;

    virtual const TString& GetName() const override {
        return Name;
    }

    virtual TVector<TString> GetInputs() const override {
        return {};
    }

    virtual void AddInputsToScheme(const IServerBase& /* server */, NDrive::TScheme& /*scheme*/) const override {

    }

    void AddParameter(EOutput parameter, const NJson::TJsonValue& json);

private:
    static TSet<EOutput> TimeParameters;
    static TSet<EOutput> MoneyParameters;
    static TString Name;
    static TFactory::TRegistrator<TPaymentTemplate> Registrator;
};


enum class ERefundOutput {
    Bill /* "bill" */,
    BillHR /* "bill_hr" */,
    BillType /* "billing_type" */,
    SessionId /* "session_id" */,
    PromocodeSum /* "promocode_sum" */,
    PromocodeSumHR /* "promocode_sum_hr" */,
    Time /* "timestamp" */,
    ExternalId /* "external_id" */,
    PaymentType /* "payment_type" */,
    AccountName /* "account_name" */,
};

class TRefundTemplate : public ITemplateDataByStorage<ERefundOutput> {
public:
    virtual bool Fetch(const NJson::TJsonValue& json, const NDrive::IServer& server, TMessagesCollector& errors) override;

    virtual const TString& GetName() const override {
        return Name;
    }

    virtual TVector<TString> GetInputs() const override {
        return{};
    }

    virtual void AddInputsToScheme(const IServerBase& /* server */, NDrive::TScheme& /*scheme*/) const override {

    }

    void AddParameter(EOutput parameter, const NJson::TJsonValue& json, const NDrive::IServer& server);

private:
    static TSet<EOutput> MoneyParameters;
    static TSet<EOutput> TimeParameters;
    static TString Name;
    static TFactory::TRegistrator<TRefundTemplate> Registrator;
};
