#include "photo_template.h"

#include <drive/backend/abstract/frontend.h>

#include <drive/library/cpp/mds/client.h>

using namespace NTemplateData;

TString TPhotoTemplate::Name("mds_photo");
TSet<TPhotoTemplate::EOutput> TPhotoTemplate::TimeParameters = { TPhotoTemplate::EOutput::Timestamp };
ITemplateData::TFactory::TRegistrator<TPhotoTemplate> TPhotoTemplate::Registrator(TPhotoTemplate::Name);

bool TPhotoTemplate::Fetch(const NJson::TJsonValue& json, const NDrive::IServer& server, TMessagesCollector& errors) {
    const auto path = json["photo_link"].GetString();
    const auto bucket = json["photo_bucket"].GetString();
    if (!path || !bucket) {
        errors.AddMessage("ui_errors", "отсутствует путь до файла");
        return false;
    }
    Storage.AddParameter(EOutput::Path, path);

    if (!server.GetMDSClient() || !server.GetMDSClient()->GetBucket(bucket)) {
        errors.AddMessage("ui_errors", "Отсутствует mds-клиент");
        return false;
    }
    TVector<TS3Client::TBucketElement> elements;
    if (server.GetMDSClient()->GetBucket(bucket)->GetKeys(path, elements) != HTTP_OK || elements.size() != 1) {
        errors.AddMessage("ui_errors", "Не удалось загрузить mds file " + path);
        return false;
    }
    Storage.AddParameter(EOutput::Timestamp, THRTime(elements.front().ModificationTime).ToString());
    return true;
}
