#pragma once

#include <drive/backend/doc_packages/template.h>

enum class EPhotoOutput {
    Path /* "path" */,
    Timestamp /* "timestamp" */,
};

class TPhotoTemplate: public ITemplateDataByStorage<EPhotoOutput> {
public:
    virtual bool Fetch(const NJson::TJsonValue& json, const NDrive::IServer& server, TMessagesCollector& errors) override;

    virtual const TString& GetName() const override {
        return Name;
    }

    virtual TVector<TString> GetInputs() const override {
        return { "photo_link" };
    }

    virtual void AddInputsToScheme(const IServerBase& /* server */, NDrive::TScheme& scheme) const override {
        if (!scheme.HasField("photo_link")) {
            scheme.Add<TFSString>("photo_link", "Путь до фото").SetRequired(true);
        }
        if (!scheme.HasField("photo_bucket")) {
            scheme.Add<TFSString>("photo_bucket", "Имя бакета").SetRequired(true);
        }
    }

private:
    static TSet<EOutput> TimeParameters;
    static TString Name;
    static TFactory::TRegistrator<TPhotoTemplate> Registrator;
};
