#include "template.h"

#include <drive/backend/abstract/frontend.h>

using namespace NTemplateData;

TString TPostTemplate::Name("post");
TString TCommonTemplate::Name("common");

ITemplateData::TFactory::TRegistrator<TPostTemplate> TPostTemplate::Registrator(TPostTemplate::Name);
ITemplateData::TFactory::TRegistrator<TCommonTemplate> TCommonTemplate::Registrator(TCommonTemplate::Name);

bool TCommonTemplate::Fetch(const NJson::TJsonValue& json, const NDrive::IServer& server, TMessagesCollector& /*errors*/) {
    Storage.AddParameter(EOutput::Now, THRDate(TInstant::Now()).ToString());
    Storage.AddParameter(EOutput::Week, THRDate(TInstant::Now() + TDuration::Days(7)).ToString());
    if (json["certified"].GetBoolean()) {
        Storage.AddParameter(EOutput::Certification, server.GetSettings().GetValueDef<TString>("document_manager.certification", ""));
    }
    return true;
}
