#pragma once

#include <drive/backend/doc_packages/template.h>

enum class ECommonOutput {
    Now /* "now" */,
    Week /* "week" */,
    Certification /* "certification" */,
};

class TCommonTemplate: public ITemplateDataByStorage<ECommonOutput> {
public:
    virtual bool Fetch(const NJson::TJsonValue& /*json*/, const NDrive::IServer& /*server*/, TMessagesCollector& /*errors*/) override;

    virtual const TString& GetName() const override {
        return Name;
    }

    virtual TVector<TString> GetInputs() const override {
        return {};
    }

    virtual void AddInputsToScheme(const IServerBase& /* server */, NDrive::TScheme& scheme) const override {
        if (!scheme.HasField("certified")) {
            scheme.Add<TFSBoolean>("certified", "Заверить").SetDefault(false);
        }
    }

private:
    static TString Name;
    static TFactory::TRegistrator<TCommonTemplate> Registrator;
};

class TPostTemplate : public ITemplateData {
public:
    virtual bool Fetch(const NJson::TJsonValue& json, const NDrive::IServer& /*server*/, TMessagesCollector& /*errors*/) override {
        PostData = json;
        return true;
    }

    virtual const TString& GetName() const override {
        return Name;
    }

    const TString& GetParameter(const TString& name) const override {
        return PostData[name].GetString();
    }

    virtual TVector<TString> GetInputs() const override {
        return {};
    }

    virtual void AddInputsToScheme(const IServerBase& /* server */, NDrive::TScheme& /*scheme*/) const override {

    }

    virtual TVector<TString> GetOutputs() const override {
        TVector<TString> result;
        for (const auto& p : PostData.GetMap()) {
            result.emplace_back(p.first);
        }
        return result;
    }

private:
    NJson::TJsonValue PostData;
    static TString Name;
    static TFactory::TRegistrator<TPostTemplate> Registrator;
};
