#pragma once

#include <drive/backend/doc_packages/template.h>

enum class EUserInput {
    UserId /* "user_id" */
};

template <class EOutput>
class IUserCommonTemplate : public ITemplateDataByStorage<EOutput> {
public:
    using EInput = EUserInput;

public:
    virtual bool Fetch(const NJson::TJsonValue& json, const NDrive::IServer& server, TMessagesCollector& errors) override {
        return Fetch(json[ToString(EInput::UserId)].GetString(), server, errors);
    }

    static TVector<TString> GetUserInputs() {
        TVector<TString> result;
        for (auto&& var : GetEnumAllValues<EInput>()) {
            result.push_back(ToString(var));
        }
        return result;
    }

    virtual TVector<TString> GetInputs() const override {
        return GetUserInputs();
    }

    virtual void AddInputsToScheme(const IServerBase& /* server */, NDrive::TScheme& scheme) const override {
        if (!scheme.HasField("user_id")) {
            scheme.Add<TFSString>("user_id", "Идентификатор пользователя").SetVisual(TFSString::EVisualType::GUID).SetRequired(true);
        }
    }

private:
    virtual bool Fetch(const TString& userId, const NDrive::IServer& server, TMessagesCollector& errors) = 0;
};

enum class EUserCommonOutput {
    Id /* "id" */,
    UserName /* "user_name" */,
    LastName /* "last_name" */,
    FirstName /* "first_name" */,
    MiddleName /* "pn" */,
    UserPhone /* "setup.phone.number" */,
    UserMail /* "setup.email.address" */,
    PassportNumber /* "documents.passport.[0].doc_value" */,
    PassportGender /* "documents.passport.[0].gender" */,
    PassportBirthPlace /* "documents.passport.[0].birth_place" */,
    PassportRegistrationArea /* "documents.passport.[0].registration_area" */,
    PassportRegistrationRegion /* "documents.passport.[0].registration_region" */,
    PassportRegistrationLocality /* "documents.passport.[0].registration_locality" */,
    PassportRegistrationStreet /* "documents.passport.[0].registration_street" */,
    PassportRegistrationHouse /* "documents.passport.[0].registration_house" */,
    PassportRegistrationApartment /* "documents.passport.[0].registration_apartment" */,
    DrivingLicenseNumber /* "documents.driving_license.[0].number_front" */,
    DrivingLicenseCategories /* "documents.driving_license.[0].categories" */,

    RegistrationDate /* "registration.approved_at" */,
    PassportIssueDate /* "documents.passport.[0].issue_date" */,
    PassportBirthDate /* "documents.passport.[0].birth_date" */,
    PassportSubdivisionCode /* "documents.passport.[0].subdivision_code" */,
    DrivingLicenseExperienceFrom /* "documents.driving_license.[0].experience_from" */,
    DrivingLicenseIssueDate /* "documents.driving_license.[0].issue_date" */,
    DrivingLicenseValidTo /* "documents.driving_license.[0].categories_b_valid_to_date" */,
};

class TUserTemplate : public IUserCommonTemplate<EUserCommonOutput> {
public:
    virtual bool Fetch(const TString& userId, const NDrive::IServer& server, TMessagesCollector& errors) override;

    virtual const TString& GetName() const override {
        return Name;
    }

    void AddParameter(EOutput parameter, const NJson::TJsonValue& json);

private:
    static TSet<EOutput> DateParameters;
    static TString Name;
    static TFactory::TRegistrator<TUserTemplate> Registrator;
};

enum class EUserPhotoOutput {
    LicenseFrontDocument /* "lf_document_id" */,
    LicenseFrontPhoto /* "lf_photo_id" */,
    LicenseBackDocument /* "lb_document_id" */,
    LicenseBackPhoto /* "lb_photo_id" */,
    PassportBiographicalDocument /* "pb_document_id" */,
    PassportBiographicalPhoto /* "pb_photo_id" */,
    PassportRegistrationDocument /* "pr_document_id" */,
    PassportRegistrationPhoto /* "pr_photo_id" */,
    PassportSelfieDocument /* "ps_document_id" */,
    PassportSelfiePhoto /* "ps_photo_id" */,
};

class TUserPhotoTemplate : public ITemplateDataByStorage<EUserPhotoOutput> {
public:
    virtual void AddInputsToScheme(const IServerBase& server, NDrive::TScheme& scheme) const override;

    virtual bool Fetch(const NJson::TJsonValue& json, const NDrive::IServer& server, TMessagesCollector& errors) override;

    virtual const TString& GetName() const override {
        return Name;
    }

    virtual TVector<TString> GetInputs() const override {
        return IUserCommonTemplate<EUserInput>::GetUserInputs();
    }

private:
    static TString Name;
    static TFactory::TRegistrator<TUserPhotoTemplate> Registrator;
};
