#include "storage.h"

bool TDocumentExternalStorageOptions::Init(const TYandexConfig::Section* section) {
    if (!section)
        return false;
    const TYandexConfig::Directives& directives = section->GetDirectives();
    AssertCorrectConfig(directives.GetValue("Type", Type), "Incorrect storage type: not specified");

    StorageConfig = IDocumentExternalStorageConfig::TFactory::Construct(Type);
    AssertCorrectConfig(!!StorageConfig, "unknown storage type " + Type);
    {
        auto sections = section->GetAllChildren();
        TYandexConfig::TSectionsMap::const_iterator iter = sections.find(Type);
        AssertCorrectConfig(StorageConfig->Init((iter == sections.end()) ? nullptr : iter->second), "Incorrect configuraton for %s", Type.data());
    }
    return true;
}

void TDocumentExternalStorageOptions::ToString(IOutputStream& os) const {
    os << "Type: " << Type << Endl;
    os << "<" << Type << ">" << Endl;
    if (StorageConfig) {
        StorageConfig->ToString(os);
    }
    os << "</" << Type << ">" << Endl;
}

TAtomicSharedPtr<IDocumentExternalStorage> TDocumentExternalStorageOptions::ConstructStorage() const {
    CHECK_WITH_LOG(!!StorageConfig);
    return StorageConfig->Construct();
}

void IDocumentExternalStorage::AddInputsToScheme(NDrive::TScheme& /* scheme */) const {
}
