#pragma once

#include <drive/backend/database/history/common.h>
#include <drive/library/cpp/scheme/scheme.h>

#include <library/cpp/object_factory/object_factory.h>
#include <library/cpp/yconf/conf.h>

#include <util/generic/ptr.h>

class IDocumentExternalStorage;

namespace NDrive {
    class IServer;
}

class IDocumentExternalStorageConfig {
public:
    using TPtr = TAtomicSharedPtr<IDocumentExternalStorageConfig>;
    using TFactory = NObjectFactory::TParametrizedObjectFactory<IDocumentExternalStorageConfig, TString>;
    virtual bool Init(const TYandexConfig::Section* section) = 0;
    virtual void ToString(IOutputStream& os) const = 0;
    virtual TAtomicSharedPtr<IDocumentExternalStorage> Construct() const = 0;
    virtual ~IDocumentExternalStorageConfig() = default;
};

class TDocumentExternalStorageOptions {
    R_READONLY(TString, Type);

public:
    bool Init(const TYandexConfig::Section* section);
    void ToString(IOutputStream& os) const;
    TAtomicSharedPtr<IDocumentExternalStorage> ConstructStorage() const;

private:
    IDocumentExternalStorageConfig::TPtr StorageConfig;
};

class IDocumentExternalStorage {
public:
    using TPtr = TAtomicSharedPtr<IDocumentExternalStorage>;
    virtual ~IDocumentExternalStorage() = default;
    virtual bool GetValue(const TString& key, const NJson::TJsonValue& postData, TString& result, const NDrive::IServer& server, TMessagesCollector& errors) const = 0;
    virtual void AddInputsToScheme(NDrive::TScheme& /* scheme */) const;
};
