#include "disk_impl.h"

#include <drive/backend/database/drive_api.h>

#include <drive/library/cpp/disk/client.h>

TAtomicSharedPtr<IDocumentExternalStorage> TYaDiskStorageOptions::Construct() const {
    return new TYaDiskStorage();
}

TYaDiskStorageOptions::TFactory::TRegistrator<TYaDiskStorageOptions> TYaDiskStorageOptions::Registrator("disk_impl");

bool TYaDiskStorage::GetValue(const TString& key, const NJson::TJsonValue& /* postData */, TString& result, const NDrive::IServer& server, TMessagesCollector& errors) const {
    if (!server.GetDriveAPI()->HasYandexDiskClient()) {
        errors.AddMessage(__LOCATION__, "disk client undefined");
        return false;
    }
    TVector<IDocumentStorage::IDocumentStorageFile::TPtr> files;
    if (!server.GetDriveAPI()->GetYandexDiskClient().GetFiles(key, files, errors)) {
        ERROR_LOG << errors.GetStringReport() << Endl;
        return false;
    }
    if (files.size() != 1) {
        errors.AddMessage(__LOCATION__, "unique file not found at given key");
        return false;
    }
    return files.front()->GetData(result, errors);
}
