#include "mds.h"

#include <drive/backend/database/drive_api.h>

#include <drive/library/cpp/mds/client.h>

bool TMDSStorageOptions::Init(const TYandexConfig::Section* section) {
    BucketName = section->GetDirectives().Value("BucketName", BucketName);
    return true;
}

void TMDSStorageOptions::ToString(IOutputStream& os) const {
    os << "BucketName: " << BucketName << Endl;
}

TAtomicSharedPtr<IDocumentExternalStorage> TMDSStorageOptions::Construct() const {
    return new TMDSStorage(*this);
}

TMDSStorageOptions::TFactory::TRegistrator<TMDSStorageOptions> TMDSStorageOptions::Registrator("mds");

TMDSStorage::TMDSStorage(const TMDSStorageOptions& selfOptions)
    : Config(selfOptions)
{}

bool TMDSStorage::GetValue(const TString& key, const NJson::TJsonValue& /* postData */, TString& result, const NDrive::IServer& server, TMessagesCollector& errors) const {
    if (!server.GetDriveAPI()->HasMDSClient()) {
        errors.AddMessage(__LOCATION__, "mds client undefined");
        return false;
    }
    auto bucket = server.GetDriveAPI()->GetMDSClient().GetBucket(Config.GetBucketName());
    if (!bucket) {
        errors.AddMessage(__LOCATION__, "bucket is not found");
        return false;
    }

    return bucket->GetFile(key, result, errors) / 100 == 2;
}
