#pragma once
#include <drive/backend/doc_packages/storage.h>

class TMDSStorageOptions : public IDocumentExternalStorageConfig {
    R_READONLY(TString, BucketName);
private:
    static TFactory::TRegistrator<TMDSStorageOptions> Registrator;
public:
    virtual bool Init(const TYandexConfig::Section* section) override;
    virtual void ToString(IOutputStream& os) const override;
    virtual TAtomicSharedPtr<IDocumentExternalStorage> Construct() const override;
};

class TMDSStorage : public IDocumentExternalStorage {
public:
    TMDSStorage(const TMDSStorageOptions& selfOptions);
    virtual bool GetValue(const TString& key, const NJson::TJsonValue& /* postData */, TString& result, const NDrive::IServer& server, TMessagesCollector& errors) const override;

private:
    TMDSStorageOptions Config;
};
