#include "settings.h"

#include <drive/backend/abstract/frontend.h>

TAtomicSharedPtr<IDocumentExternalStorage> TSettingsStorageOptions::Construct() const {
    return new TSettingsStorage();
}

TSettingsStorageOptions::TFactory::TRegistrator<TSettingsStorageOptions> TSettingsStorageOptions::Registrator("gvars");

bool TSettingsStorage::GetValue(const TString& key, const NJson::TJsonValue& /* postData */, TString& result, const NDrive::IServer& server, TMessagesCollector& /*errors*/) const {
    return server.GetSettings().GetValue(key, result);
}
