#include "simple_client.h"

#include <library/cpp/string_utils/url/url.h>

bool TClientStorageOptions::Init(const TYandexConfig::Section* section) {
    RequestTimeout = section->GetDirectives().Value<TDuration>("RequestTimeout", RequestTimeout);
    TAsyncApiImpl::TConfig::Init(section, nullptr);
    return true;
}

void TClientStorageOptions::ToString(IOutputStream& os) const {
    TAsyncApiImpl::TConfig::ToString(os);
    os << "RequestTimeout: " << RequestTimeout << Endl;
}

TAtomicSharedPtr<IDocumentExternalStorage> TClientStorageOptions::Construct() const {
    return new TClientStorage(*this);
}

TClientStorageOptions::TFactory::TRegistrator<TClientStorageOptions> TClientStorageOptions::Registrator("simple_client");

TClientStorage::TClientStorage(const TClientStorageOptions& selfOptions)
    : Client(selfOptions)
    , RequestTimeout(selfOptions.GetRequestTimeout())
{}

bool TClientStorage::GetValue(const TString& key, const NJson::TJsonValue& /* postData */, TString& result, const NDrive::IServer& /*server*/, TMessagesCollector& errors) const {
    TInstant deadline = Now() + RequestTimeout;
    NNeh::THttpRequest request;
    request.SetUri(key);
    DEBUG_LOG << request.GetDebugRequest() << Endl;
    auto reply = Client->SendMessageSync(request, deadline);
    if (reply.Code() == HTTP_FOUND || reply.Code() == HTTP_MOVED_PERMANENTLY) {
        for (const auto& header : reply.GetHeaders()) {
            if (header.Name() == "Location") {
                TString host, path;
                SplitUrlToHostAndPath(header.Value(), host, path);
                NNeh::THttpClient newClient(host, Client.GetCommonConfig().GetRequestConfig());
                deadline = Now() + RequestTimeout;
                NNeh::THttpRequest newRequest;
                newRequest.SetUri(path);
                DEBUG_LOG << newRequest.GetDebugRequest() << Endl;
                reply = newClient.SendMessageSync(newRequest, deadline);
                break;
            }
        }
    }
    if (!reply.IsSuccessReply()) {
        errors.AddMessage("error", ToString(reply.Code()) + " " + reply.Content() + " "+ reply.ErrorMessage());
        ERROR_LOG << reply.Code() << " " << reply.Content() << " " << reply.ErrorMessage() << Endl;
        return false;
    }
    result = reply.Content();
    return true;
}
