#pragma once
#include <drive/backend/doc_packages/storage.h>

#include <rtline/library/deprecated/async_impl/async_impl.h>

class TClientStorageOptions : public IDocumentExternalStorageConfig, public TAsyncApiImpl::TConfig {
    R_READONLY(TDuration, RequestTimeout, TDuration::Seconds(1));
private:
    static TFactory::TRegistrator<TClientStorageOptions> Registrator;
public:
    virtual bool Init(const TYandexConfig::Section* section) override;
    virtual void ToString(IOutputStream& os) const override;
    virtual TAtomicSharedPtr<IDocumentExternalStorage> Construct() const override;
};

class TClientStorage : public IDocumentExternalStorage {
public:
    TClientStorage(const TClientStorageOptions& selfOptions);
    virtual bool GetValue(const TString& key, const NJson::TJsonValue& /* postData */, TString& result, const NDrive::IServer& server, TMessagesCollector& errors) const override;

private:
    TAsyncApiImpl Client;
    TDuration RequestTimeout;
};
