#include "user_photos.h"

#include <drive/backend/database/drive_api.h>
#include <drive/backend/user_document_photos/manager.h>

TAtomicSharedPtr<IDocumentExternalStorage> TUserPhotosStorageOptions::Construct() const {
    return new TUserPhotosStorage();
}

TUserPhotosStorageOptions::TFactory::TRegistrator<TUserPhotosStorageOptions> TUserPhotosStorageOptions::Registrator("user_photos");

void TUserPhotosStorage::AddInputsToScheme(NDrive::TScheme& scheme) const {
    if (!scheme.HasField("uid")) {
        scheme.Add<TFSNumeric>("uid", "Идентификатор паспорта");
    }
}

bool TUserPhotosStorage::GetValue(const TString& key, const NJson::TJsonValue& postData, TString& result, const NDrive::IServer& server, TMessagesCollector& errors) const {
    if (!server.GetDriveAPI()->HasDocumentPhotosManager()) {
        errors.AddMessage(__LOCATION__, "user photos manager undefined");
        return false;
    }
    const TString externalUid = postData.Has("uid") ? postData["uid"].GetStringRobust() : "";
    if (!server.GetDriveAPI()->GetDocumentPhotosManager().GetDocumentPhoto(key, result, server)
        && (!externalUid || !server.GetDriveAPI()->GetDocumentPhotosManager().GetDocumentPhoto(key, result, server, externalUid)))
    {
        errors.AddMessage(__LOCATION__, "cannot download photo " + key);
        errors.AddMessage("ui_errors", "Фото не найдено");
        ERROR_LOG << errors.GetStringReport() << Endl;
        return false;
    }
    return true;
}
