#include "template.h"

TString NTemplateData::GetDurationString(TDuration d) {
    TStringBuilder ss;
    if (d.Days() > 0) {
        ss << d.Days() << "д ";
        d -= TDuration::Days(d.Days());
    }
    if (d.Hours() > 0) {
        ss << d.Hours() << "ч ";
        d -= TDuration::Hours(d.Hours());
    }
    if (d.Minutes() > 0) {
        ss << d.Minutes() << "мин ";
        d -= TDuration::Minutes(d.Minutes());
    }
    ss << d.Seconds() << "c";
    return ss;
}

bool ITemplateData::BuildFromPostData(TMap<TString, ITemplateData::TPtr>& result, const NJson::TJsonValue& json, const TSet<TString>& templates, const NDrive::IServer& server, TMessagesCollector& errors) {
    TSet<TString> keys;
    for (auto key : templates) {
        TPtr parameter = TFactory::Construct(key);
        if (!parameter) {
            errors.AddMessage("build_templates", "undefined template type");
            return false;
        }
        if (!parameter->Fetch(json, server, errors)) {
            return false;
        }
        parameter->FetchOverride(json);
        result[key] = parameter;
    }
    return true;
}

NJson::TJsonValue ITemplateData::GetFullScheme(const IServerBase& server) {
    NJson::TJsonValue scheme;
    TSet<TString> templateTypes;
    TFactory::GetRegisteredKeys(templateTypes);
    for (auto&& type : templateTypes) {
        THolder<ITemplateData> templateData(TFactory::Construct(type));
        scheme.InsertValue(type, templateData->GetScheme(server));
    }
    return scheme;
}

NJson::TJsonValue ITemplateData::GetScheme(const IServerBase& server) const {
    NJson::TJsonValue scheme;
    scheme.InsertValue("inputs", GetInputsScheme(server).SerializeToJson());

    NDrive::TScheme outputsScheme;
    for (const auto& parameter : GetOutputs()) {
        outputsScheme.Add<TFSString>(parameter);
    }
    scheme.InsertValue("outputs", outputsScheme.SerializeToJson());
    return scheme;
}

NJson::TJsonValue ITemplateData::GetSchemeJson() const {
    NJson::TJsonValue templateInfo;
    templateInfo["name"] = GetName();
    for (const auto& parameter : GetInputs()) {
        templateInfo["inputs"].AppendValue(parameter);
    }
    for (const auto& parameter : GetOutputs()) {
        templateInfo["outputs"].AppendValue(parameter);
    }
    return templateInfo;
}
