#include "config.h"

#include <library/cpp/mediator/global_notifications/system_status.h>

#include <util/stream/file.h>

TSet<NUserDocument::EType> TDocumentsVerificationConfig::DefaultDocumentTypes = {
    NUserDocument::EType::LicenseBack,
    NUserDocument::EType::LicenseFront,
    NUserDocument::EType::PassportBiographical,
    NUserDocument::EType::PassportRegistration,
    NUserDocument::EType::PassportSelfie
};

void TDocumentsVerificationConfig::Init(const TYandexConfig::Section* section) {
    RequestsPath = section->GetDirectives().Value<TString>("RequestsPath", RequestsPath);
    ResultsPath = section->GetDirectives().Value<TString>("ResultsPath", ResultsPath);
    TempRequestsPath = section->GetDirectives().Value<TString>("TempRequestsPath", TempRequestsPath);
    NotifierName = section->GetDirectives().Value<TString>("NotifierName", NotifierName);
    {
        TString clustersStr;
        clustersStr = section->GetDirectives().Value<TString>("YtClusters", clustersStr);
        YtClusters = SplitString(clustersStr, ",");
    }

    {
        TString geoStr;
        geoStr = section->GetDirectives().Value<TString>("Geo", geoStr);
        auto highPriGeoVector = SplitString(geoStr, ",");
        Geo = TSet<TString>(highPriGeoVector.begin(), highPriGeoVector.end());
    }
    MaxPoolSize = section->GetDirectives().Value<ui32>("MaxPoolSize", MaxPoolSize);
    AreAssignmentsExperimental = section->GetDirectives().Value<ui32>("AreAssignmentsExperimental", AreAssignmentsExperimental);
}

void TDocumentsVerificationConfig::ToString(IOutputStream& os) const {
    os << "RequestsPath: " << RequestsPath << Endl;
    os << "ResultsPath: " << ResultsPath << Endl;
    os << "TempRequestsPath: " << TempRequestsPath << Endl;
    os << "NotifierName: " << NotifierName << Endl;
    os << "YtClusters: " << JoinStrings(YtClusters.begin(), YtClusters.end(), ",") << Endl;
    os << "Geo: " << JoinStrings(Geo.begin(), Geo.end(), ",") << Endl;
    os << "MaxPoolSize: " << MaxPoolSize << Endl;
    os << "AreAssignmentsExperimental: " << (ui32)(AreAssignmentsExperimental) << Endl;
}

TDocumentsVerificationConfig TDocumentsVerificationConfig::ParseFromString(const TString& configStr) {
    TDocumentsVerificationConfig result;
    TAnyYandexConfig config;
    CHECK_WITH_LOG(config.ParseMemory(configStr.data()));
    result.Init(config.GetRootSection());
    return result;
}

TVector<TString> TDocumentsVerificationConfig::GetGeoVector() const {
    return TVector<TString>(Geo.begin(), Geo.end());
}
