#pragma once

#include <drive/backend/users/user_documents.h>

#include <kernel/daemon/config/daemon_config.h>

#include <library/cpp/logger/global/global.h>

#include <rtline/util/types/accessor.h>

#include <util/generic/set.h>
#include <util/string/vector.h>

class TDocumentsVerificationConfig {
public:
    static TSet<NUserDocument::EType> DefaultDocumentTypes;

public:
    enum ETaskType {
        CustomPackage /* "custom_package" */,
        DocumentsPackage /* "documents_package" */,
        FaceMatching /* "face_matching" */,
    };

private:
    // YT- related settings
    R_FIELD(TString, RequestsPath);
    R_FIELD(TString, TempRequestsPath);
    R_FIELD(TString, ResultsPath);
    R_FIELD(TVector<TString>, YtClusters, { "hahn" });

    R_FIELD(ui32, MaxPoolSize, 100);
    R_FIELD(TSet<TString>, Geo);

    R_FIELD(TString, NotifierName);

    R_FIELD(bool, AreAssignmentsExperimental, false);
    R_FIELD(ETaskType, TaskType, ETaskType::DocumentsPackage);
    R_FIELD(TSet<NUserDocument::EType>, DocumentTypes);
    R_FIELD(TSet<TString>, RequiredOriginChats);
    R_FIELD(TSet<TString>, RequiredChatNodes);
    R_FIELD(bool, RequireRecognizerMeta, false);

public:
    void Init(const TYandexConfig::Section* section);
    void ToString(IOutputStream& os) const;

    TVector<TString> GetGeoVector() const;

    static TDocumentsVerificationConfig ParseFromString(const TString& configStr);
};
