#pragma once

#include "config.h"

#include <drive/backend/user_document_photos/manager.h>
#include <drive/backend/yang/client.h>

#include <rtline/library/storage/structured.h>

class TDocumentsVerificationManager {
private:
    TDocumentsVerificationConfig Config;
    TDocumentPhotosManager& UserDocumentPhotosManager;
    THolder<TYangYTClient<TYangDocumentVerificationAssignment>> YangClient;
    THolder<TYangYTClient<TYangVideoScreencapAssignment>> YangScreencapClient;

    void FilterAssignments(const TVector<TYangDocumentVerificationAssignment>& assignments, TVector<TYangDocumentVerificationAssignment>& result, const NDrive::IServer* server) const;
    bool CreatePools(TVector<TYangDocumentVerificationAssignment>& assignments, const TString& rootPath, const TString& tempPath, NDrive::TEntitySession& session) const;
    bool RegisterNewAssignments(const TVector<TYangDocumentVerificationAssignment>& assignments, const TString& poolsPath, const TString& tempPath, const NDrive::IServer* server, NDrive::TEntitySession& session) const;
    bool CleanupTempPools(NDrive::TEntitySession& session) const;
    void UpdatePhotoVerificationInfo(TUserDocumentPhoto& photo, const TString& receivedStatus) const;
    bool GetAssignmentsMeta(const TSet<TString>& userIds, TMap<TString, NJson::TJsonValue>& metaMap) const;
    bool RemoveAssignmentTags(const TVector<TYangDocumentVerificationAssignment>& assignments, const TString& tagToRemove, const TString& operatorUserId, const NDrive::IServer* server, NDrive::TEntitySession& session) const;

public:
    TDocumentsVerificationManager(const TDocumentsVerificationConfig& config, TDocumentPhotosManager& userPhotoManager);
    bool CreateNewAssignments(const TInstant since, const NDrive::IServer* server, NDrive::TEntitySession& session) const;
    bool CreateNewCustomAssignments(const TInstant since, const NDrive::IServer* server, NDrive::TEntitySession& session) const;
    bool CreateNewSelfieAssignments(const NDrive::IServer* server, NDrive::TEntitySession& session) const;
    bool CreateNewRegistrationAssignments(const TInstant since, const NDrive::IServer* server, NDrive::TEntitySession& session) const;
    bool ResendToYang(const TSet<TString>& userIds, const TString& tagToRemove, const TString& operatorUserId, const NDrive::IServer* server) const;
    bool ResendToYangByPhotoIds(const TSet<TString>& photoIds, const TString& tagToRemove, const TString& operatorUserId, const NDrive::IServer* server, NDrive::TEntitySession& session) const;
};
