#include "manager.h"

NDrivematics::TSignal::TDecoder::TDecoder(const TMap<TString, ui32>& decoderBase) {
    Id = GetFieldDecodeIndex("id", decoderBase);
    Name = GetFieldDecodeIndex("name", decoderBase);
    Type = GetFieldDecodeIndex("type", decoderBase);
    ObjectId = GetFieldDecodeIndex("object_id", decoderBase);
    SessionId = GetFieldDecodeIndex("session_id", decoderBase);
    UserId = GetFieldDecodeIndex("user_id", decoderBase);
    Resolution = GetFieldDecodeIndex("resolution", decoderBase);
    Start = GetFieldDecodeIndex("start", decoderBase);
    Finish = GetFieldDecodeIndex("finish", decoderBase);
    Visible = GetFieldDecodeIndex("visible", decoderBase);
}

NSQL::TTableRecord NDrivematics::TSignal::SerializeToTableRecord() const {
    NSQL::TTableRecord result;
    result.Set("id", Id);
    result.Set("name", Name);
    result.Set("type", Type);
    if (ObjectId) {
        result.Set("object_id", ObjectId);
    }
    if (SessionId) {
        result.Set("session_id", SessionId);
    }
    if (UserId) {
        result.Set("user_id", UserId);
    }
    if (Resolution) {
        result.Set("resolution", Resolution);
    }
    if (Start) {
        result.Set("start", Start.Seconds());
    }
    if (Finish) {
        result.Set("finish", Finish.Seconds());
    }
    if (Visible) {
        result.Set("visible", *Visible);
    }
    return result;
}

bool NDrivematics::TSignal::DeserializeWithDecoder(const TDecoder& decoder, TConstArrayRef<TStringBuf> values, const IHistoryContext* historyContext) {
    Y_UNUSED(historyContext);
    READ_DECODER_VALUE(decoder, values, Id);
    READ_DECODER_VALUE(decoder, values, Name);
    READ_DECODER_VALUE(decoder, values, Type);
    READ_DECODER_VALUE(decoder, values, ObjectId);
    READ_DECODER_VALUE(decoder, values, SessionId);
    READ_DECODER_VALUE(decoder, values, UserId);
    READ_DECODER_VALUE(decoder, values, Resolution);
    READ_DECODER_VALUE_INSTANT(decoder, values, Start);
    if (decoder.GetFinish() >= 0 && !values[decoder.GetFinish()].empty()) {
        READ_DECODER_VALUE_INSTANT(decoder, values, Finish);
    }
    if (decoder.GetVisible() >= 0 && !values[decoder.GetVisible()].empty()) {
        bool visible;
        READ_DECODER_VALUE_TEMP(decoder, values, visible, Visible);
        Visible = visible;
    }
    return true;
}

NDrivematics::TSignalManager::TOptionalEntities NDrivematics::TSignalManager::Fetch(NDrive::TEntitySession& tx, TQueryOptions&& queryOptions) const {
    if (queryOptions.HasIds()) {
        queryOptions.SetGenericCondition("id", std::cref(queryOptions.GetIdsRef()));
    }
    if (queryOptions.HasNames()) {
        queryOptions.SetGenericCondition("name", std::cref(queryOptions.GetNamesRef()));
    }
    if (queryOptions.HasObjectIds()) {
        if (queryOptions.GetIsOrObjectIds()) {
            queryOptions.MutableSubOrOptions().emplace_back(NSQL::TQueryOptions().SetGenericCondition("object_id", std::cref(queryOptions.GetObjectIdsRef())));
        } else {
            queryOptions.SetGenericCondition("object_id", std::cref(queryOptions.GetObjectIdsRef()));
        }
    }
    if (queryOptions.HasSessionIds()) {
        if (queryOptions.GetIsOrSessionIds()) {
            queryOptions.MutableSubOrOptions().emplace_back(NSQL::TQueryOptions().SetGenericCondition("session_id", std::cref(queryOptions.GetSessionIdsRef())));
        } else {
            queryOptions.SetGenericCondition("session_id", std::cref(queryOptions.GetSessionIdsRef()));
        }
    }
    if (queryOptions.HasUserIds()) {
        if (queryOptions.GetIsOrUserIds()) {
            queryOptions.MutableSubOrOptions().emplace_back(NSQL::TQueryOptions().SetGenericCondition("user_id", std::cref(queryOptions.GetUserIdsRef())));
        } else {
            queryOptions.SetGenericCondition("user_id", std::cref(queryOptions.GetUserIdsRef()));
        }
    }
    if (queryOptions.GetActualDef(false)) {
        queryOptions.SetGenericCondition("finish", TNull());
    }
    if (queryOptions.GetVisibleDef(false)) {
        queryOptions.SetGenericCondition("visible", NSQL::Not(false));
    }
    auto since = queryOptions.HasSince() ? MakeMaybe(queryOptions.GetSinceRef().Seconds()) : Nothing();
    auto until = queryOptions.HasUntil() ? MakeMaybe(queryOptions.GetUntilRef().Seconds()) : Nothing();
    auto range = MakeRange<ui64>(since, until);
    if (range) {
        queryOptions.SetGenericCondition("start", range);
    }
    if (queryOptions.GetOrderBy().empty()) {
        queryOptions.SetOrderBy({
            "start",
            "id",
        });
    }
    return TBase::Fetch(tx, queryOptions);
}
