#include "tags.h"

bool NDrivematics::TGenericSignalCarTag::OnBeforeRemove(const TDBTag& self, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& tx) {
    Y_UNUSED(userId);
    Y_UNUSED(server);
    auto timestamp = Now();
    if (!SetFinish(timestamp, tx)) {
        return false;
    }
    return UpdateSignal(self, tx);
}

NDrivematics::NProto::TGenericSignalCarTag NDrivematics::TGenericSignalCarTag::DoSerializeSpecialDataToProto() const {
    auto result = TBase::DoSerializeSpecialDataToProto();
    if (auto signalTagTraits = result.MutableSignalTagTraits()) {
        Serialize(*signalTagTraits);
    }
    return result;
}

bool NDrivematics::TGenericSignalCarTag::DoDeserializeSpecialDataFromProto(const NDrivematics::NProto::TGenericSignalCarTag& proto) {
    if (!TBase::DoDeserializeSpecialDataFromProto(proto)) {
        return false;
    }
    if (proto.HasSignalTagTraits() && !Deserialize(proto.GetSignalTagTraits())) {
        return false;
    }
    return true;
}

bool NDrivematics::TGenericSignalUserTag::OnBeforeRemove(const TDBTag& self, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& tx) {
    Y_UNUSED(userId);
    Y_UNUSED(server);
    auto timestamp = Now();
    if (!SetFinish(timestamp, tx)) {
        return false;
    }
    return UpdateSignal(self, tx);
}

NDrivematics::NProto::TGenericSignalUserTag NDrivematics::TGenericSignalUserTag::DoSerializeSpecialDataToProto() const {
    auto result = TBase::DoSerializeSpecialDataToProto();
    if (auto signalTagTraits = result.MutableSignalTagTraits()) {
        Serialize(*signalTagTraits);
    }
    return result;
}

bool NDrivematics::TGenericSignalUserTag::DoDeserializeSpecialDataFromProto(const NDrivematics::NProto::TGenericSignalUserTag& proto) {
    if (!TBase::DoDeserializeSpecialDataFromProto(proto)) {
        return false;
    }
    if (proto.HasSignalTagTraits() && !Deserialize(proto.GetSignalTagTraits())) {
        return false;
    }
    return true;
}

NDrive::ITag::TFactory::TRegistrator<NDrivematics::TGenericSignalCarTag> NDrivematics::TGenericSignalCarTag::Registrator(NDrivematics::TGenericSignalCarTag::Type());
NDrive::ITag::TFactory::TRegistrator<NDrivematics::TGenericSignalUserTag> NDrivematics::TGenericSignalUserTag::Registrator(NDrivematics::TGenericSignalUserTag::Type());
