#pragma once

#include <drive/backend/drivematics/signal/tag.h>
#include <drive/backend/drivematics/signals/proto/tags.pb.h>

namespace NDrivematics {
    class TGenericSignalCarTag: public ISerializableTag<NProto::TGenericSignalCarTag, /*variativeRead=*/true, TCommonSignalTag> {
    private:
        using TBase = ISerializableTag<NProto::TGenericSignalCarTag, /*variativeRead=*/true, TCommonSignalTag>;

    public:
        static TString Type() {
            return "generic_signal_car_tag";
        }

    public:
        using TBase::TBase;

        EUniquePolicy GetUniquePolicy() const override {
            return EUniquePolicy::SkipIfExists;
        }

        bool OnBeforeRemove(const TDBTag& self, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& tx) override;

    protected:
        NEntityTagsManager::EEntityType GetEntityType() const override {
            return NEntityTagsManager::EEntityType::Car;
        }

        NProto::TGenericSignalCarTag DoSerializeSpecialDataToProto() const override;
        bool DoDeserializeSpecialDataFromProto(const NProto::TGenericSignalCarTag& proto) override;

    private:
        static TFactory::TRegistrator<TGenericSignalCarTag> Registrator;
    };

    class TGenericSignalUserTag: public ISerializableTag<NProto::TGenericSignalUserTag, /*variativeRead=*/true, TCommonSignalTag> {
    private:
        using TBase = ISerializableTag<NProto::TGenericSignalUserTag, /*variativeRead=*/true, TCommonSignalTag>;

    public:
        static TString Type() {
            return "generic_signal_user_tag";
        }

    public:
        using TBase::TBase;

        EUniquePolicy GetUniquePolicy() const override {
            return EUniquePolicy::SkipIfExists;
        }

        bool OnBeforeRemove(const TDBTag& self, const TString& userId, const NDrive::IServer* server, NDrive::TEntitySession& tx) override;

    protected:
        NEntityTagsManager::EEntityType GetEntityType() const override {
            return NEntityTagsManager::EEntityType::User;
        }

        NProto::TGenericSignalUserTag DoSerializeSpecialDataToProto() const override;
        bool DoDeserializeSpecialDataFromProto(const NProto::TGenericSignalUserTag& proto) override;

    private:
        static TFactory::TRegistrator<TGenericSignalUserTag> Registrator;
    };
}
