#include "context.h"

#include <drive/backend/logging/events.h>

#include <library/cpp/json/json_reader.h>
#include <library/cpp/string_utils/base64/base64.h>

#include <rtline/library/json/builder.h>

#include <util/string/split.h>

NDrive::TExperimentContext::TExperimentContext(IReplyContext::TPtr context) {
    if (!context) {
        return;
    }
    const TStringBuf flags = context->GetRequestData().HeaderInOrEmpty("X-Yandex-ExpFlags");
    Initialize(flags);
}

NDrive::TExperimentContext::TExperimentContext(TStringBuf flags) {
    Initialize(flags);
}

void NDrive::TExperimentContext::Initialize(TStringBuf flags) {
    if (flags) {
        for (auto&& i : StringSplitter(flags).Split(',')) {
            TStringBuf encoded = i.Token();
            try {
                TString decoded = Base64Decode(encoded);
                NJson::TJsonValue parsed = NJson::ReadJsonFastTree(decoded);
                Y_ENSURE(parsed.IsArray());
                for (auto&& i : parsed.GetArraySafe()) {
                    const TString& handler = i["HANDLER"].GetStringSafe();
                    if (handler != ExperimentHandler) {
                        continue;
                    }
                    const NJson::TJsonValue& disabledRoles = i["CONTEXT"][ExperimentHandler]["disabled_roles"];
                    if (disabledRoles.IsDefined()) {
                        for (auto&& action : disabledRoles.GetArraySafe()) {
                            DisabledRoles.insert(action.GetStringSafe());
                        }
                    }
                    const NJson::TJsonValue& recursiveDisabledRoles = i["CONTEXT"][ExperimentHandler]["recursive_disabled_roles"];
                    if (recursiveDisabledRoles.IsDefined()) {
                        for (auto&& action : recursiveDisabledRoles.GetArraySafe()) {
                            RecursiveDisabledRoles.insert(action.GetStringSafe());
                        }
                    }
                    const NJson::TJsonValue& enabledRoles = i["CONTEXT"][ExperimentHandler]["enabled_roles"];
                    if (enabledRoles.IsDefined()) {
                        for (auto&& role : enabledRoles.GetArraySafe()) {
                            EnabledRoles.insert(role.GetStringSafe());
                        }
                    }
                }
            } catch (const std::exception& e) {
                NDrive::TEventLog::Log("ExpFlagsParseError", NJson::TMapBuilder
                    ("encoded", encoded)
                    ("error", FormatExc(e))
                );
            }
        }
    }
}
