#pragma once

#include <drive/library/cpp/searchserver/context/replier.h>

#include <util/generic/set.h>

namespace NDrive {
    constexpr TStringBuf ExperimentHandler = "DRIVE_MOBILE";

    class TExperimentContext {
    public:
        TExperimentContext(IReplyContext::TPtr context);
        TExperimentContext(TStringBuf flags);

        const TSet<TString>& GetDisabledRoles() const {
            return DisabledRoles;
        }
        const TSet<TString>& GetRecursiveDisabledRoles() const {
            return RecursiveDisabledRoles;
        }
        const TSet<TString>& GetEnabledRoles() const {
            return EnabledRoles;
        }

    private:
        void Initialize(TStringBuf flags);

    private:
        TSet<TString> DisabledRoles;
        TSet<TString> RecursiveDisabledRoles;
        TSet<TString> EnabledRoles;
    };
}
