#include "context.h"

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(ExperimentsContext) {
    Y_UNIT_TEST(Simple) {
        TString expFlags = "W3siSEFORExFUiI6IkRSSVZFX01PQklMRSIsIkNPTlRFWFQiOnsiRFJJVkVfTU9CSUxFIjp7ImVuYWJsZWRfcm9sZXMiOlsiZXhwZXJpbWVudGFsX3JvbGUiXX19fV0=";
        NDrive::TExperimentContext context(expFlags);
        const auto& roles = context.GetEnabledRoles();
        UNIT_ASSERT_VALUES_EQUAL(roles.size(), 1);
        UNIT_ASSERT_VALUES_EQUAL(*roles.begin(), "experimental_role");
    }
    Y_UNIT_TEST(RecursiveDisableRoles) {
        TStringStream ss;
        ss << "W3siSEFORExFUiI6IkRSSVZFX01PQklMRSIsIkNPTlRFWFQiOnsiRFJJVkVfTU9CSUxFIjp7InJlY3Vyc2l2ZV9kaXNhYmxlZF9y";
        ss << "b2xlcyI6WyJ0ZXN0X3JvbGUxIiwgInRlc3Rfcm9sZTIiXX19fV0=";
        NDrive::TExperimentContext context(ss.Str());
        const auto& roles = context.GetRecursiveDisabledRoles();
        UNIT_ASSERT_VALUES_EQUAL(roles, (TSet<TString>{"test_role1", "test_role2"}));
    }
}
