#include "db_accessors.h"

namespace NDrive::NFine {
    TString TFineDB::GetTableName() const {
        return "autocode_fine";
    }

    TString TFineDB::GetMainId(const TAutocodeFineEntry& e) const {
        return e.GetId();
    }

    void TFineDB::UpdateUniqueCondition(NStorage::TTableRecord& unique, const TAutocodeFineEntry& entity) const {
        unique.Set("serial_id", entity.GetSerialId());
    }

    TMaybe<TVector<i64>> TFineDB::GetFineAmountsCents(NDrive::TEntitySession& tx, const NSQL::TQueryOptions& options) const {
        TRecordsSet records;
        auto query = options.PrintQuery(*tx.GetTransaction(), GetTableName(), {
            "sum_to_pay",
        });
        auto queryResult = tx->Exec(query, &records);
        if (!ParseQueryResult(queryResult, tx)) {
            return {};
        }
        TVector<i64> result;
        for (auto&& record : records) {
            double amount = 0;
            if (!record.TryGet("sum_to_pay", amount)) {
                tx.SetErrorInfo("GetFineAmountsCents", "Fail to parse record");
            }
            result.push_back(amount * 100);
        }
        return result;
    }

    TString TFineAttachmentManager::GetTableName() const {
        return TAutocodeFineAttachmentEntry::GetTableName();
    }

    TString TFineAttachmentManager::GetMainId(const TAutocodeFineAttachmentEntry& e) const {
        return e.GetId();
    }

    void TFineAttachmentManager::UpdateUniqueCondition(NStorage::TTableRecord& unique, const TAutocodeFineAttachmentEntry& entity) const {
        unique.Set("serial_id", entity.GetSerialId());
    }
}
