#pragma once

#include "entries.h"

#include <drive/backend/database/entity/manager.h>
#include <drive/backend/database/history/cache.h>
#include <drive/backend/database/transaction/tx.h>

namespace NDrive::NFine {
    using TOptionalFine = TMaybe<TAutocodeFineEntry>;
    using TOptionalFines = TMaybe<TVector<TAutocodeFineEntry>>;

    class TFineDB: public TDatabaseEntityManager<TAutocodeFineEntry> {
        using TBase = TDatabaseEntityManager<TAutocodeFineEntry>;
    public:
        using TBase::TBase;
        TString GetTableName() const override;
        TString GetMainId(const TAutocodeFineEntry& e) const override;
        void UpdateUniqueCondition(NStorage::TTableRecord& unique, const TAutocodeFineEntry& entity) const override;
        TMaybe<TVector<i64>> GetFineAmountsCents(NDrive::TEntitySession& tx, const NSQL::TQueryOptions& options) const;
    };

    class TFineAttachmentManager : public TDatabaseEntityManager<TAutocodeFineAttachmentEntry>  {
        using TBase = TDatabaseEntityManager<TAutocodeFineAttachmentEntry>;

    public:
        using TBase::TBase;
        virtual TString GetTableName() const override;
        TString GetMainId(const TAutocodeFineAttachmentEntry& e) const override;
        void UpdateUniqueCondition(NStorage::TTableRecord& unique, const TAutocodeFineAttachmentEntry& entity) const override;
    };
}
