#pragma once

#include <drive/backend/fines/autocode/entries.h>
#include <drive/backend/fines/config.h>
#include <drive/backend/fines/manager.h>

#include <drive/backend/major/entities.h>

#include <drive/library/cpp/autocode/entities.h>
#include <drive/library/cpp/element/entities.h>

#include <rtline/util/types/accessor.h>
#include <rtline/util/types/messages_collector.h>

namespace NDrive {
    class IServer;
}

namespace NDrive::NFine {
    class TFineAttachmentConstructor {
        using TAutocodeFinePhoto = NDrive::NAutocode::TAutocodeFinePhoto;
        using TCarPenaltyDecree = NMajorClient::TCarPenaltyDecreeRequest::TCarPenaltyDecree;
        using TElementPenaltyPhoto = NDrive::TElementFineAttachment;

    public:
        using TKnownAttachmentMap = TMap<TString, TVector<TAutocodeFineAttachmentEntry>>;

    public:
        TFineAttachmentConstructor(const TFineAttachmentConstructorConfig& config, const NDrive::IServer& server);

        bool Init(const NDrive::NFine::TFinesManager& manager, const TSet<TString>& fineIds, NDrive::TEntitySession& tx);

        const TFineAttachmentConstructorConfig& GetConfig() const;

        bool ConstructAutocodeFineAttachmentEntry(const TString& fineId, const TAutocodeFinePhoto& finePhoto, TAutocodeFineAttachmentEntry& fineAttachmentEntry, TMessagesCollector& errors) const;
        bool ConstructAutocodeFineAttachmentEntry(const TString& fineId, const TElementPenaltyPhoto& penaltyDecree, TAutocodeFineAttachmentEntry& fineAttachmentEntry, TMessagesCollector& errors) const;
        bool ConstructAutocodeFineAttachmentEntry(const TString& fineId, const TCarPenaltyDecree& penaltyDecree, TAutocodeFineAttachmentEntry& fineAttachmentEntry, TMessagesCollector& errors) const;

    private:
        bool ConstructAutocodeFineAttachmentEntry(const TString& fineId, const TAutocodeFineAttachmentEntry::EDataType dateType, const TString& data, TAutocodeFineAttachmentEntry& fineAttachmentEntry, TMessagesCollector& errors) const;
        bool UploadAttachment(const TString& fineId, const TString& fileName, const TString& data, TString& filePath, TMessagesCollector& errors) const;

        const TFineAttachmentConstructorConfig Config;
        const NDrive::IServer& Server;
        R_FIELD(TKnownAttachmentMap, KnownPhotos);
        R_FIELD(TKnownAttachmentMap, KnownDegrees);
    };
}
