#include "tag_constructor.h"

#include <drive/backend/fines/autocode/entries.h>
#include <drive/backend/fines/context_fetchers/fine_context.h>

#include <drive/backend/data/billing_tags.h>
#include <drive/backend/data/notifications_tags.h>
#include <drive/backend/data/common/serializable.h>
#include <drive/backend/database/drive_api.h>

#include <drive/library/cpp/scheme/scheme.h>

#include <rtline/util/json_processing.h>

namespace NDrive::NFine {
    bool IFineTagConfig::IsTagNullable() const {
        return !IsEnabled();
    }

    ITag::TPtr IFineTagConfig::CreateTag(const TFineFetchContext& context, TMessagesCollector& errors) const {
        if (!Enabled) {
            return nullptr;
        }

        const auto& tagsManager = context.GetServer().GetDriveAPI()->GetTagsManager();

        TString tagName = GetTagName(context, errors);
        TString tagData = GetTagData(context, errors);

        NJson::TJsonValue tagDataJson;
        if (!NJson::ReadJsonTree(tagData, &tagDataJson)) {
            errors.AddMessage(__LOCATION__, TStringBuilder() << "Error parsing tag data json: " << tagData);
            return nullptr;
        }

        tagDataJson["tag_name"] = tagName;

        ITag::TPtr tagPtr = IJsonSerializableTag::BuildFromJson(tagsManager, tagDataJson, &errors);
        if (!tagPtr) {
            errors.AddMessage(__LOCATION__, TStringBuilder() << "Invalid tag data for fine " << context.GetEntry().GetId() << ": " << tagDataJson.GetStringRobust());
            return nullptr;
        }

        return tagPtr;
    }

    TString IFineTagConfig::GetTagName(const TFineFetchContext& context, TMessagesCollector& errors) const {
        return IFineContextFetcher::ProcessText(TagNameTemplate, context, errors);
    }

    TString IFineTagConfig::GetTagData(const TFineFetchContext& context, TMessagesCollector& errors) const {
        return IFineContextFetcher::ProcessText(TagDataTemplate, context, errors);
    }

    TString TFineDefaultTagConfig::TSchemeSettings::GetTagNameKey() {
        return "";
    }

    TString TFineDefaultTagConfig::TSchemeSettings::GetTagDataKey() {
        return "";
    }

    TString TFineChargeTagConfig::TSchemeSettings::GetTagNameKey() {
        return "fines.tag_templates.charge_tag.name";
    }

    TString TFineChargeTagConfig::TSchemeSettings::GetTagDataKey() {
        return "fines.tag_templates.charge_tag.data";
    }

    TString TFineMailTagConfig::TSchemeSettings::GetTagNameKey() {
        return "fines.tag_templates.mail_tag.name";
    }

    TString TFineMailTagConfig::TSchemeSettings::GetTagDataKey() {
        return "fines.tag_templates.mail_tag.data";
    }

    TString TFinePushTagConfig::TSchemeSettings::GetTagNameKey() {
        return "fines.tag_templates.push_tag.name";
    }

    TString TFinePushTagConfig::TSchemeSettings::GetTagDataKey() {
        return "fines.tag_templates.push_tag.data";
    }

    TString TFineRefundTagConfig::TSchemeSettings::GetTagNameKey() {
        return "fines.tag_templates.refund_tag.name";
    }

    TString TFineRefundTagConfig::TSchemeSettings::GetTagDataKey() {
        return "fines.tag_templates.refund_tag.data";
    }
};
