#include "fine_base.h"

#include <drive/backend/database/drive_api.h>
#include <drive/backend/fines/autocode/entries.h>

#include <drive/backend/abstract/frontend.h>

#include <util/string/join.h>

namespace NDrive::NFine {
    TFineFetchContext::TFineFetchContext(const TFineFetchContextConfig& config, const NDrive::IServer& server, const TAutocodeFineEntry& entry, const TDynamicContext& dynamicContext)
        : TBase(server, entry, dynamicContext)
        , Config(config)
    {
    }

    bool TFineFetchContext::PrefetchPhotos(NDrive::TEntitySession& tx) const {
        if (HasPrefechedPhotos()) {
            return true;
        }
        const auto& finesManager = GetServer().GetDriveAPI()->GetFinesManager();
        SetPrefechedPhotos(finesManager.GetFineAttachments(GetEntry().GetId(), NDrive::NFine::TFinesManager::EFineAttachmentType::Photo, tx));
        return HasPrefechedPhotos();
    }

    const TMaybe<TFineAttachmentManager::TEntities>& TFineFetchContext::GetPrefetchedPhotos(TMessagesCollector& errors, NDrive::TEntitySession* txPtr /* = nullptr */) const {
        if (!HasPrefechedPhotos()) {
            if (!txPtr) {
                auto tx = GetServer().GetDriveAPI()->GetFinesManager().BuildTx<NSQL::ReadOnly>();
                if (!PrefetchPhotos(tx)) {
                    errors.AddMessage(__LOCATION__, "Fail to fetch fine attachmans: " + tx.GetStringReport());
                }

            } else {
                if (!PrefetchPhotos(*txPtr)) {
                    errors.AddMessage(__LOCATION__, "Fail to fetch fine attachmans: " + txPtr->GetStringReport());
                }
            }
        }
        return PrefechedPhotos;
    }

    const TString IFineContextFetcher::TypeNamePrefix = "fine.";
}
