#pragma once

#include "fine_config.h"

#include <drive/backend/database/transaction/tx.h>
#include <drive/backend/context_fetcher/base.h>
#include <drive/backend/fines/manager.h>

#include <drive/library/cpp/context_fetcher/fetcher.h>

namespace NDrive::NFine {
    class TAutocodeFineEntry;

    class TFineFetchContext: public TFetchContext<TAutocodeFineEntry, TEntryConstRefHolder<TAutocodeFineEntry>> {
        using TBase = TFetchContext<TAutocodeFineEntry, TEntryConstRefHolder<TAutocodeFineEntry>>;

    public:
        TFineFetchContext(const TFineFetchContextConfig& config, const NDrive::IServer& server, const TAutocodeFineEntry& entry, const TDynamicContext& dynamicContext = {});

        const TFineFetchContextConfig& GetConfig() const {
            return Config;
        }

        const TMaybe<TFineAttachmentManager::TEntities>& GetPrefetchedPhotos(TMessagesCollector& errors, NDrive::TEntitySession* tx = nullptr) const;

    private:
        bool PrefetchPhotos(NDrive::TEntitySession& tx) const;

    private:
        const TFineFetchContextConfig& Config;

        R_OPTIONAL(TFineAttachmentManager::TEntities, PrefechedPhotos, {}, mutable);
    };

    class IFineContextFetcher: public IContextFetcher<IFineContextFetcher, TFineFetchContext> {
        using TBase = IContextFetcher<IFineContextFetcher, TFineFetchContext>;

    public:
        using TBase::TBase;

    protected:
        static const TString TypeNamePrefix;
    };
}
