#pragma once

#include <drive/library/cpp/raw_text/datetime.h>
#include <drive/library/cpp/tex_builder/tex_builder.h>

#include <rtline/util/types/accessor.h>

namespace NDrive {
    class TScheme;
}

namespace NJson {
    class TJsonValue;
}

namespace NDrive::NFine {
    class TFineFetchContextConfig {
        class TViolationDetailedDocumentConfig {
            R_READONLY(NTexBuilder::TTexBuilderConfig, TexBuilderConfig);

            R_READONLY(bool, UseCachedOnly, true);

            R_READONLY(TString, RobotUserId, DefaultRobotUserId);
            R_READONLY(TString, AttachmentFilename, DefaultAttachmentFilename);
            R_READONLY(TString, MDSBucketName, DefaultMDSBucketName);
            R_READONLY(TString, MDSFilePrefix, DefaultMDSFilePrefix);
            R_READONLY(TString, TexTemplateName, DefaultTexTemplateName);

        public:
            static NDrive::TScheme GetScheme();

            bool DeserializeFromJson(const NJson::TJsonValue& data);
            NJson::TJsonValue SerializeToJson() const;

        private:
            static const TString DefaultRobotUserId;
            static const TString DefaultAttachmentFilename;
            static const TString DefaultMDSBucketName;
            static const TString DefaultMDSFilePrefix;
            static const TString DefaultTexTemplateName;
        };

        R_READONLY(TString, RulingDateFormat, DefaultRulingDateFormat);
        R_READONLY(TString, ViolationTimeFormat, DefaultViolationTimeFormat);
        R_READONLY(NUtil::TTimeZone, ViolationTimeZone, NUtil::GetTimeZone(DefaultViolationTimeZone));

        R_READONLY(TViolationDetailedDocumentConfig, ViolationDetailedDocumentConfig);

        R_READONLY(TString, PhotoBlockTitleTemplate, DefaultPhotoBlockTitleTemplate);
        R_READONLY(TVector<TString>, PhotoBlockTitleVariants, DefaultPhotoBlockTitleVariants);

        R_READONLY(TString, PhotoBlockImageTemplate, DefaultPhotoBlockImageTemplate);

    public:
        static NDrive::TScheme GetScheme();

        bool DeserializeFromJson(const NJson::TJsonValue& data);
        NJson::TJsonValue SerializeToJson() const;

        static const TString PhotoBlockTitlePlaceHolder;
        static const TString PhotoBlockImagePlaceHolder;

    private:
        static const TString DefaultRulingDateFormat;
        static const TString DefaultViolationTimeFormat;
        static const TString DefaultViolationTimeZone;

        static const TString DefaultPhotoBlockTitleTemplate;
        static const TVector<TString> DefaultPhotoBlockTitleVariants;

        static const TString DefaultPhotoBlockImageTemplate;
    };
}
