#pragma once

#include "fine_base.h"

#include <rtline/util/types/messages_collector.h>

class TDriveCarInfo;
class TDriveUserData;

namespace NDrive::NFine {
    class TFineIdContextFetcher : public IFineContextFetcher {
        using TBase = IFineContextFetcher;

    public:
        using TBase::TBase;

        virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

        static TString GetTypeName();

    private:
        using TRegistrator = TFactory::TRegistrator<TFineIdContextFetcher>;
        static TRegistrator Registrator;
    };

    class TFineRulingNumberContextFetcher : public IFineContextFetcher {
        using TBase = IFineContextFetcher;

    public:
        using TBase::TBase;

        virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

        static TString GetTypeName();

    private:
        using TRegistrator = TFactory::TRegistrator<TFineRulingNumberContextFetcher>;
        static TRegistrator Registrator;
    };

    class TFineSourceTypeContextFetcher : public IFineContextFetcher {
        using TBase = IFineContextFetcher;

    public:
        using TBase::TBase;

        virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

        static TString GetTypeName();

    private:
        using TRegistrator = TFactory::TRegistrator<TFineSourceTypeContextFetcher>;
        static TRegistrator Registrator;
    };

    class TFineArticleContextFetcher : public IFineContextFetcher {
        using TBase = IFineContextFetcher;

    public:
        using TBase::TBase;

        virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

        static TString GetTypeName();

    private:
        using TRegistrator = TFactory::TRegistrator<TFineArticleContextFetcher>;
        static TRegistrator Registrator;
    };

    class TFineArticleCodeContextFetcher : public IFineContextFetcher {
        using TBase = IFineContextFetcher;

    public:
        using TBase::TBase;

        virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

        static TString GetTypeName();

    private:
        using TRegistrator = TFactory::TRegistrator<TFineArticleCodeContextFetcher>;
        static TRegistrator Registrator;
    };

    // fine violation session details fetchers

    class TFineSessionIdContextFetcher : public IFineContextFetcher {
        using TBase = IFineContextFetcher;

    public:
        using TBase::TBase;

        virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

        static TString GetTypeName();

    private:
        using TRegistrator = TFactory::TRegistrator<TFineSessionIdContextFetcher>;
        static TRegistrator Registrator;
    };

    class TFineUserIdContextFetcher : public IFineContextFetcher {
        using TBase = IFineContextFetcher;

    public:
        using TBase::TBase;

        virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

        static TString GetTypeName();

    private:
        using TRegistrator = TFactory::TRegistrator<TFineUserIdContextFetcher>;
        static TRegistrator Registrator;
    };

    class TFineFullUserNameContextFetcher : public IFineContextFetcher {
        using TBase = IFineContextFetcher;

    public:
        using TBase::TBase;

        virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

        static TString GetTypeName();

    protected:
        bool FetchUser(const IFineContextFetcher::TContextType& context, TDriveUserData& userData, TMessagesCollector& errors) const;

    private:
        using TRegistrator = TFactory::TRegistrator<TFineFullUserNameContextFetcher>;
        static TRegistrator Registrator;
    };

    // fine violation details fetchers

    class TFineRulingDateContextFetcher : public IFineContextFetcher {
        using TBase = IFineContextFetcher;

    public:
        using TBase::TBase;

        virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

        static TString GetTypeName();

    private:
        using TRegistrator = TFactory::TRegistrator<TFineRulingDateContextFetcher>;
        static TRegistrator Registrator;
    };

    class TFineLawnParkingDeadlineContextFetcher : public IFineContextFetcher {
        using TBase = IFineContextFetcher;

    public:
        using TBase::TBase;

        virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

        static TString GetTypeName();

    private:
        using TRegistrator = TFactory::TRegistrator<TFineLawnParkingDeadlineContextFetcher>;
        static TRegistrator Registrator;
    };

    class TFineViolationPlaceContextFetcher : public IFineContextFetcher {
        using TBase = IFineContextFetcher;

    public:
        using TBase::TBase;

        virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

        static TString GetTypeName();

    private:
        using TRegistrator = TFactory::TRegistrator<TFineViolationPlaceContextFetcher>;
        static TRegistrator Registrator;
    };

    class TFineViolationTimeContextFetcher : public IFineContextFetcher {
        using TBase = IFineContextFetcher;

    public:
        using TBase::TBase;

        virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

        static TString GetTypeName();

    private:
        using TRegistrator = TFactory::TRegistrator<TFineViolationTimeContextFetcher>;
        static TRegistrator Registrator;
    };

    class TFineViolationPhotoBlockContextFetcher : public IFineContextFetcher {
        using TBase = IFineContextFetcher;

    public:
        using TBase::TBase;

        virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

        static TString GetTypeName();

    private:
        using TRegistrator = TFactory::TRegistrator<TFineViolationPhotoBlockContextFetcher>;
        static TRegistrator Registrator;
    };

    class TFineViolationDetailedDocumentContextFetcher : public IFineContextFetcher {
        using TBase = IFineContextFetcher;

    public:
        using TBase::TBase;

        virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

        static TString GetTypeName();

    private:
        using TRegistrator = TFactory::TRegistrator<TFineViolationDetailedDocumentContextFetcher>;
        static TRegistrator Registrator;
    };

    class TFineViolationDetailedDocumentUrlContextFetcher : public IFineContextFetcher {
        using TBase = IFineContextFetcher;

    public:
        using TBase::TBase;

        virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

        static TString GetTypeName();

    private:
        bool GetDocument(const IFineContextFetcher::TContextType& context, TBlob& document, TMessagesCollector& errors) const;
        bool UploadToMDS(const IFineContextFetcher::TContextType& context, const TBlob& document, TString& fileUrl, TMessagesCollector& errors) const;

        using TRegistrator = TFactory::TRegistrator<TFineViolationDetailedDocumentUrlContextFetcher>;
        static TRegistrator Registrator;
    };

    class TFineChargeTagNameContextFetcher : public IFineContextFetcher {
        using TBase = IFineContextFetcher;

    public:
        using TBase::TBase;

        virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

        static TString GetTypeName();

    private:
        using TRegistrator = TFactory::TRegistrator<TFineChargeTagNameContextFetcher>;
        static TRegistrator Registrator;
    };

    class TFineMailTagNameContextFetcher : public IFineContextFetcher {
        using TBase = IFineContextFetcher;

    public:
        using TBase::TBase;

        virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

        static TString GetTypeName();

    private:
        using TRegistrator = TFactory::TRegistrator<TFineMailTagNameContextFetcher>;
        static TRegistrator Registrator;
    };

    // fine payment total fetchers

    class TFinePaymentTotalContextFetcher : public IFineContextFetcher {
        using TBase = IFineContextFetcher;

    public:
        using TBase::TBase;

        virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

        static TString GetTypeName();

    private:
        using TRegistrator = TFactory::TRegistrator<TFinePaymentTotalContextFetcher>;
        static TRegistrator Registrator;
    };

    class TFinePaymentCentsTotalContextFetcher : public IFineContextFetcher {
        using TBase = IFineContextFetcher;

    public:
        using TBase::TBase;

        virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

        static TString GetTypeName();

    private:
        using TRegistrator = TFactory::TRegistrator<TFinePaymentCentsTotalContextFetcher>;
        static TRegistrator Registrator;
    };

    class TFinePaymentTotalWithoutDiscountContextFetcher : public IFineContextFetcher {
        using TBase = IFineContextFetcher;

    public:
        using TBase::TBase;

        virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

        static TString GetTypeName();

    private:
        using TRegistrator = TFactory::TRegistrator<TFinePaymentTotalWithoutDiscountContextFetcher>;
        static TRegistrator Registrator;
    };

    // fine charge context fetchers

    class TFineChargeTagIdContextFetcher : public IFineContextFetcher {
        using TBase = IFineContextFetcher;

    public:
        using TBase::TBase;

        virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

        static TString GetTypeName();

    private:
        using TRegistrator = TFactory::TRegistrator<TFineChargeTagIdContextFetcher>;
        static TRegistrator Registrator;
    };

    // fine car context fetchers

    class IFineCarContextFetcher : public IFineContextFetcher {
        using TBase = IFineContextFetcher;

    protected:
        using TBase::TBase;

        bool FetchCar(const TContextType& context, TDriveCarInfo& carData, TMessagesCollector& errors) const;

        static const TString TypeNamePrefix;
    };

    class TFineCarModelContextFetcher : public IFineCarContextFetcher {
        using TBase = IFineCarContextFetcher;

    public:
        using TBase::TBase;

        virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

        static TString GetTypeName();

    private:
        using TRegistrator = TFactory::TRegistrator<TFineCarModelContextFetcher>;
        static TRegistrator Registrator;
    };

    class TFineCarNumberContextFetcher : public IFineCarContextFetcher {
        using TBase = IFineCarContextFetcher;

    public:
        using TBase::TBase;

        virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

        static TString GetTypeName();

    private:
        using TRegistrator = TFactory::TRegistrator<TFineCarNumberContextFetcher>;
        static TRegistrator Registrator;
    };

    class TFineCarVinContextFetcher : public IFineCarContextFetcher {
        using TBase = IFineCarContextFetcher;

    public:
        using TBase::TBase;

        virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

        static TString GetTypeName();

    private:
        using TRegistrator = TFactory::TRegistrator<TFineCarVinContextFetcher>;
        static TRegistrator Registrator;
    };

    // startrek integration

    class TFineLastStartrekTicketKeyContextFetcher : public IFineContextFetcher {
        using TBase = IFineContextFetcher;

    public:
        using TBase::TBase;

        virtual bool Fetch(const TContextType& context, TString& result, TMessagesCollector& errors) const override;

        static TString GetTypeName();

    private:
        TString GetSpecificStartrekQueue() const;

        using TRegistrator = TFactory::TRegistrator<TFineLastStartrekTicketKeyContextFetcher>;
        static TRegistrator Registrator;
    };
}
