#pragma once

#include "article_matcher.h"
#include "config.h"
#include "constants.h"
#include "filters.h"

#include <drive/backend/fines/autocode/db_accessors.h>

#include <drive/backend/database/transaction/tx.h>

#include <rtline/library/storage/structured.h>

namespace NDrive {
    class IServer;
}

namespace NDrive::NFine {
    class TFinesManager: public TDatabaseSessionConstructor {
    public:
        using EFineAttachmentType = TAutocodeFineAttachmentEntry::EDataType;

        TFinesManager(const IHistoryContext& context, const TFinesManagerConfig& config, const NDrive::IServer& server);

        const NDrive::IServer& GetServer() const {
            return Server;
        }

        const TFinesManagerConfig& GetConfig() const {
            return Config;
        }

        TFineArticleMatcher::TPtr GetFineArticleMatcherPtr(const bool ensureActual) const;

        TOptionalFines GetFines(const TFineFilterGroup& filterGroup, NDrive::TEntitySession& tx, NSQL::TQueryOptions options = {}) const;
        TOptionalFine GetFineById(const TString& id, NDrive::TEntitySession& tx, NSQL::TQueryOptions options = {}) const;
        TOptionalFines GetFinesByUserId(const TString& userId, const TFineFilterGroup& filterGroup, NDrive::TEntitySession& tx, NSQL::TQueryOptions options = {}) const;
        TOptionalFines GetFinesByCarId(const TString& carId, const TFineFilterGroup& filterGroup, NDrive::TEntitySession& tx, NSQL::TQueryOptions options = {}) const;
        TOptionalFines GetFinesBySessionIds(const TSet<TString>& sessionIds, const TFineFilterGroup& filterGroup, NDrive::TEntitySession& tx, NSQL::TQueryOptions options = {}) const;
        TMaybe<TVector<i64>> GetFineAmounts(const TFineFilterGroup& filterGroup, NDrive::TEntitySession& tx, NSQL::TQueryOptions options = {}) const;

        bool UpsertFine(const TAutocodeFineEntry& fine, NDrive::TEntitySession& tx) const;
        bool UpsertFineNotCharged(const TAutocodeFineEntry& fine, NDrive::TEntitySession& tx) const;

        TFineAttachmentManager::TOptionalEntities GetFineAttachments(const TString& fineId, const EFineAttachmentType attachmentType, NDrive::TEntitySession& tx) const;
        TFineAttachmentManager::TOptionalEntities GetFineAttachments(const TSet<TString>& fineIds, const EFineAttachmentType attachmentType, NDrive::TEntitySession& tx) const;

        bool UpsertFineAttachment(const TAutocodeFineAttachmentEntry& fineAttachment, NDrive::TEntitySession& tx) const;

    private:
        TFinesManagerConfig Config;
        const NDrive::IServer& Server;

        mutable TFineArticleMatcher::TPtr FineArticleMatcher;

        TFineDB FineDB;
        TFineAttachmentManager FineAttachmentManager;
    };
}
