#pragma once

#include <util/generic/string.h>

namespace NTestDriveFueling {

    constexpr TStringBuf CreatePath = "/api/order/create";
    constexpr TStringBuf InfoPostPath = "/api/order/post/status";
    constexpr TStringBuf InfoPath = "/api/order/status";
    constexpr TStringBuf CancelPath = "/api/order/user/canceled";
    constexpr TStringBuf MapPath = "/api/station";

    const TString WrongOrderId = "wrongorderid";
    const TString WrongOrderIdWithError = "wrongorderidwitherror";

    const TString OkReply = "HTTP/1.1 200 Ok\r\n\r\n";
    const TString BadRequestReply = "HTTP/1.1 400 Bad Request\r\n\r\n";
    const TString NotFoundReply = "HTTP/1.1 404 Not Found\r\n\r\n";

    const TString FreeColumnState = R"(
{
    "status": "Free"
}
)";

    const TString PetrolColumnFor100Premium = "3";

    const TString DefaultFuelingColumnState = R"(
{
    "status": "Fueling",
    "litre": 10.0,
    "fuelId": "a92",
    "fuel": {
        "id": "a92",
        "marka": "АИ-92"
    },
    "basePriceFuel": 20.78,
    "sum": 417.8
)";

    const TString DefaultCompletedColumnState = R"(
{
    "status": "Completed",
    "litre": 20.0,
    "fuelId": "a92",
    "fuel": {
        "id": "a92",
        "marka": "АИ-92"
    },
    "basePriceFuel": 41.56,
    "sum": 831.2
}
)";

    const TString Fueling100PremiumColumnState = R"(
{
    "status": "Fueling",
    "litre": 10.0,
    "fuelId": "a100_premium",
    "fuel": {
        "id": "a100_premium",
        "marka": "АИ-100"
    },
    "basePriceFuel": 20.78,
    "sum": 417.8
)";

    const TString Completed100PremiumColumnState = R"(
{
    "status": "Completed",
    "litre": 20.0,
    "fuelId": "a100_premium",
    "fuel": {
        "id": "a100_premium",
        "marka": "АИ-100"
    },
    "basePriceFuel": 41.56,
    "sum": 831.2
}
)";

    const TString MapJson = R"(
[
    {
        "id": "46e2059185f44d61b6aa578b1415ec49",
        "name": "Тестировочная №1",
        "address": "Кремлевская наб. 1",
        "location": {
            "lon": 37.6224932711628,
            "lat": 55.7531181890418
        },
        "polygon": [
            {
                "lon": 37.622385327734605,
                "lat": 55.753645130275551
            },
            {
                "lon": 37.621351305192206,
                "lat": 55.753089659982159
            },
            {
                "lon": 37.622338358942784,
                "lat": 55.752570522313867
            },
            {
                "lon": 37.623377744237018,
                "lat": 55.753174302033663
            },
            {
                "lon": 37.622385327734605,
                "lat": 55.753645130275551
            }
        ],
        "columns": {
            "1": {
                "fuels": [
                    "a92",
                    "a95",
                    "diesel",
                ]
            },
            "4": {
                "fuels": [
                    "a92_premium",
                    "a95",
                    "a98_premium",
                    "diesel_winter",
                    "diesel_premium"
                ]
            },
        },
        "fuels": [
            {
                "id": "a92",
                "marka": "АИ-92"
            },
            {
                "id": "a95",
                "marka": "АИ-95"
            },
            {
                "id": "diesel",
                "marka": "ДТ"
            }
        ]
    },
    {
        "id": "1702571f75f597a20bacfcd221e6654c",
        "name": "Тестировочная №2 POST",
        "address": "Россия, Московская область, Ленинский район, посёлок Володарского, Центральная улица",
        "location": {
            "lon": 37.625277404119,
            "lat": 55.7541649361069
        },
        "polygon": [
            {
                "lon": 37.625620071351683,
                "lat": 55.754713766950758
            },
            {
                "lon": 37.624215904871576,
                "lat": 55.754290236820758
            },
            {
                "lon": 37.62577158693307,
                "lat": 55.752635893858539
            },
            {
                "lon": 37.6277131862231,
                "lat": 55.753030312266318
            },
            {
                "lon": 37.625620071351683,
                "lat": 55.754713766950758
            }
        ],
        "columns": {
            "1": {
                "fuels": [
                    "a100",
                    "a92",
                    "a95",
                    "a98",
                    "a100_premium",
                    "diesel"
                ]
            },
            "3": {
                "fuels": [
                    "a100",
                    "a100_premium"
                ]
            },
            "4": {
                "fuels": [
                    "a92_premium",
                    "a95",
                    "a98_premium",
                    "diesel",
                    "diesel_winter",
                    "diesel_premium"
                ]
            },
            "8": {
                "fuels": [
                    "a92"
                ]
            }
        },
        "fuels": [
            {
                "id": "a92",
                "marka": "АИ-92"
            },
            {
                "id": "a95",
                "marka": "АИ-95"
            },
            {
                "id": "diesel",
                "marka": "ДТ"
            },
            {
                "id": "a100",
                "marka": "А-100",
            },
            {
                "id": "a100_premium",
                "marka": "АИ-100",
            },
        ],
        "postPayPolling": true
    },
    {
        "id": "cbc76e307257453b8953f46c15d90df1",
        "name": "BP Test",
        "address": "Россия, Москва, ЮВАО, Южно-Портовый, Волгоградский пр-т, д. 24, стр.1",
        "location": {
            "lon": 37.6016314834666,
            "lat": 55.7514285379185
        },
        "polygon": [
            {
                "lon": 37.60206533787732,
                "lat": 55.751686962868213
            },
            {
                "lon": 37.60152217634765,
                "lat": 55.751667297538852
            },
            {
                "lon": 37.601489990672412,
                "lat": 55.75119734123178
            },
            {
                "lon": 37.601968777519843,
                "lat": 55.751341050917112
            },
            {
                "lon": 37.60206533787732,
                "lat": 55.751686962868213
            }
        ],
        "columns": {
            "1": {
                "fuels": [
                    "a92",
                    "a95",
                    "a95_premium",
                    "a100_premium",
                    "diesel_premium"
                ]
            }
        },
        "fuels": [
            {
                "id": "a92",
                "marka": "АИ-92"
            },
            {
                "id": "a95",
                "marka": "АИ-95"
            },
            {
                "id": "a95_premium",
                "name": "Pulsar",
                "marka": "АИ-95"
            },
            {
                "id": "a100_premium",
                "name": "Pulsar",
                "marka": "АИ-100"
            },
            {
                "id": "diesel_premium",
                "name": "Pulsar",
                "marka": "ДТ"
            }
        ]
    }
]
)";

}
