#pragma once

#include <library/cpp/http/server/http.h>
#include <drive/backend/fueling_manager/fueling_manager.h>


struct TFuelingState {
    TString OrderId;
    TString ApiKey;
    EFuelingStatus Status;
    EFuelType FuelId;
    double Liters;
    TString StationId;
    TString ColumnId;

    TString GetReport() const {
        NJson::TJsonValue json;
        json["id"] = OrderId;
        json["apikey"] = ApiKey;
        json["status"] = ToString(Status);
        json["fuelId"] = ToString(FuelId);
        json["orderType"] = "Liters",
        json["orderVolume"] = Liters;
        json["stationId"] = StationId;
        json["columnId"] = ColumnId;
        return json.GetStringRobust();
    }

    bool Parse(const TMap<TString, TString>& data);
};

class TTankerEmulator : public THttpServer::ICallBack {
public:
    TTankerEmulator() = default;
    void Run(ui16 httpPort);
    virtual TClientRequest* CreateClient() override;
    ~TTankerEmulator();

    TMap<TString, TFuelingState>& GetStates() {
        return StatesMap;
    }

private:
    THolder<THttpServer> Server;
    TMap<TString, TFuelingState> StatesMap;
};
