#pragma once

#include "tag.h"

#include <drive/backend/tags/tags_filter.h>

class TDriveAPI;
class TCompiledRiding;
class TFullCompiledRiding;

class TGame {
public:
    class TConfig {
        R_FIELD(TString, OfferBuilderAttrsFilter);
        R_FIELD(TSet<TString>, OfferBuildersBlackList);
        R_FIELD(bool, FilterCorp, true);
        R_FIELD(ui32, MinMileage, 0);
        R_FIELD(TInstant, FirstSessionInstant);
        R_FIELD(TInstant, LastSessionInstant, TInstant::Max());
        R_FIELD(TString, GameTag);
        R_FIELD(TString, HomeWorkTag);
        R_FIELD(TString, DisableGameTag);
        R_FIELD(ui32, LocalLimit, 60);
        R_READONLY(TTagsFilter, TagsFilter);

        static void GetScheme(const IServerBase& server, NDrive::TScheme& scheme);
        static TMaybe<TConfig> BuildFromString(const TString& configString);
        static TMaybe<TConfig> BuildFromSettings(const ISettings& settings);

        bool DeserializeFromJson(const NJson::TJsonValue& jsonInfo);
        void SerializeToJson(NJson::TJsonValue&) const;
    };

    TGame(const TDriveAPI& driveApi, const TConfig& config)
        : DriveApi(driveApi)
        , Config(config)
    {}

    TDBTag GetUserGameTag(const TString& userId) const;
    std::pair<bool, TString> CheckSessionDeep(const TFullCompiledRiding& fullRiding) const;

private:
    const TDriveAPI& DriveApi;
    const TConfig& Config;
};
