#pragma once

#include <drive/backend/data/user_tags.h>
#include <drive/backend/data/proto/tags.pb.h>
#include <drive/backend/proto/tags.pb.h>


class TGameTagDescription : public TTagDescription {
private:
    R_READONLY(TVector<TInstant>, Deadlines);
    R_READONLY(ui32, DeltaLimit, 1000);
    using TBase = TTagDescription;

public:
    virtual NDrive::TScheme GetScheme(const NDrive::IServer* server) const override {
        NDrive::TScheme result = TBase::GetScheme(server);
        result.Add<TFSNumeric>("point_limit", "Ограничение на размер разового начисления");

        NDrive::TScheme& dates = result.Add<TFSArray>("dates", "Даты розыгрышей").SetElement<NDrive::TScheme>();
        dates.Add<TFSNumeric>("date", "Дата").SetVisual(TFSNumeric::EVisualType::DateTime);
        return result;
    }

    virtual NJson::TJsonValue DoSerializeMetaToJson() const override;
    virtual bool DoDeserializeMetaFromJson(const NJson::TJsonValue& jsonMeta) override;
};

class TGameTag : public TUserProblemTag {
private:
    using TBase = TUserProblemTag;
    using TTimeline = TMap<TInstant, ui32>;

    R_FIELD(ui32, Balance, 0);
    R_FIELD(TTimeline, GameIds);
    R_FIELD(TTimeline, Balance2Week);

public:
    using TBase::TBase;

    virtual bool OnAfterAdd(const TDBTag& /*self*/, const TString& /*userId*/, const NDrive::IServer* /*server*/, NDrive::TEntitySession& /*session*/) const override {
        return true;
    }

    virtual bool OnAfterRemove(const TDBTag& /*self*/, const TString& /*userId*/, const NDrive::IServer* /*server*/, NDrive::TEntitySession& /*session*/) const override {
        return true;
    }


    virtual NDrive::TScheme GetScheme(const NDrive::IServer* server) const override;
    virtual void SerializeSpecialDataToJson(NJson::TJsonValue& json) const override;
    virtual bool DoSpecialDataFromJson(const NJson::TJsonValue& json, TMessagesCollector* errors) override;

    virtual TProto DoSerializeSpecialDataToProto() const override;
    virtual bool DoDeserializeSpecialDataFromProto(const TProto& proto) override;

    virtual EUniquePolicy GetUniquePolicy() const override {
        return EUniquePolicy::SkipIfExists;
    }

    virtual TSet<NEntityTagsManager::EEntityType> GetObjectType() const override {
        return { NEntityTagsManager::EEntityType::User };
    }

    ui32 AddPoints(const TGameTagDescription& description, const ui32 points, const TInstant timestamp);
    bool SetGameId(const TGameTagDescription& description, const ui32 id, const TInstant timestamp);

    static ui32 GetFullBalance(const TDBTag& tag);
    static ui32 GetLocalBalance(const TGameTagDescription& description, const TDBTag& tag, const TInstant time);
    static ui32 GetLocalBalance(const TGameTagDescription& description, const TGameTag& gameTag, const TInstant timestamp);

    static TMaybe<ui32> GetGameId(const TGameTagDescription& description, const TDBTag& tag, const TInstant time);
    static TMaybe<ui32> GetGameId(const TGameTagDescription& description, const TGameTag& gameTag, const TInstant time);

    static TMaybe<TInstant> GetIntervalStart(const TGameTagDescription& description, const TInstant timestamp);

    static const TString TypeName;
private:
    static TFactory::TRegistrator<TGameTag> Registrator;
    static TTagDescription::TFactory::TRegistrator<TGameTagDescription> RegistratorDescription;
};
