#pragma once
#include <drive/backend/database/entity/manager.h>
#include <drive/backend/database/history/cache.h>
#include <drive/backend/database/history/db_entities.h>
#include <drive/backend/database/history/event.h>
#include <drive/backend/database/history/manager.h>

#include <rtline/util/types/accessor.h>

class TPublicKeyInfo {
public:
    using TId = TString;

    class TDecoder : public TBaseDecoder {
        R_FIELD(i32, OwnerId, -1);
        R_FIELD(i32, PublicKey, -1);

    public:
        TDecoder() = default;

        TDecoder(const TMap<TString, ui32>& decoderBase) {
            OwnerId = GetFieldDecodeIndex("owner_id", decoderBase);
            PublicKey = GetFieldDecodeIndex("public_key", decoderBase);
        }
    };

    TPublicKeyInfo() = default;

    NStorage::TTableRecord SerializeToTableRecord() const {
        NStorage::TTableRecord result;
        result.Set("owner_id", OwnerId);
        result.Set("public_key", PublicKey);
        return result;
    }

    bool DeserializeWithDecoder(const TDecoder& decoder, const TConstArrayRef<TStringBuf>& values, const IHistoryContext* /*hContext*/) {
        READ_DECODER_VALUE(decoder, values, OwnerId);
        READ_DECODER_VALUE(decoder, values, PublicKey);
        return true;
    }

    bool DeserializeWithDecoderVerbose(const TDecoder& decoder, const TConstArrayRef<TStringBuf>& values, TMessagesCollector& /*errors*/, const IHistoryContext* hContext) {
        return DeserializeWithDecoder(decoder, values, hContext);
    }

    static TString GetHistoryTableName() {
        return "public_keys_history";
    }

    static TString GetTableName() {
        return "public_keys";
    }

    using TObjectId = TString;

    TObjectId GetInternalId() const {
        return OwnerId;
    }

    bool operator!() const {
        return true;
    }

private:
    R_READONLY(TString, OwnerId);
    R_READONLY(TString, PublicKey);
};


class TPublicKeysCache : public TDBEntitiesCache<TPublicKeyInfo> {
private:
    using TBase = TDBEntitiesCache<TPublicKeyInfo>;
public:
    using TBase::TBase;
};
