#include "session.h"


bool THeadSession::DeserializeWithDecoder(const TDecoder& decoder, const TConstArrayRef<TStringBuf>& values, const IHistoryContext* /*hContext*/) {
    READ_DECODER_VALUE(decoder, values, UserId);
    READ_DECODER_VALUE(decoder, values, CarId);
    READ_DECODER_VALUE(decoder, values, DummyId);
    READ_DECODER_VALUE(decoder, values, HeadId);
    READ_DECODER_VALUE(decoder, values, PassportKey);
    READ_DECODER_VALUE(decoder, values, PassportKeyStatus);
    READ_DECODER_VALUE(decoder, values, LaunchAppFlag);

    if (decoder.GetHeadDeviceId() != -1) {
        READ_DECODER_VALUE(decoder, values, HeadDeviceId);
    }
    return true;
}


bool THeadSession::Parse(const NStorage::TTableRecord& record) {
    return TBaseDecoder::DeserializeFromTableRecord(*this, record);
}

NStorage::TTableRecord THeadSession::SerializeToTableRecord() const {
    NStorage::TTableRecord record;
    record.Set("user_id", UserId);
    record.Set("car_id", CarId);
    record.Set("dummy_id", DummyId);
    record.Set("head_id", HeadId);
    record.Set("head_device_id", HeadDeviceId);
    record.Set("launch_app", LaunchAppFlag);
    record.Set("passport_key", PassportKey);
    record.Set("passport_key_status", PassportKeyStatus);
    return record;
}
