#pragma once

#include <drive/backend/proto/drive.pb.h>

#include <library/cpp/json/json_value.h>

#include <rtline/util/types/accessor.h>
#include <rtline/util/types/messages_collector.h>

#include <util/generic/serialized_enum.h>

enum class EDamageLevel : ui32 {
    NoDamage /* "no_damage" */ = 0,
    Broken /* "broken" */ = 1,
    Scratch /* "scratch" */ = 2,
    Absence /* "absence" */ = 3,
    Crack /* "crack" */ = 4,
    Dint /* "dint" */ = 5,
    Stiker /* "sticker" */ = 6,
    Hole /* "hole" */ = 7,
    Error /* "error" */ = 8,
    HardDamage /* "hard_damage" */ = 9,
    LightSticker /* "light_sticker" */ = 10,
    LightScratch /* "light_scratch" */ = 11,
    LightHole /* "light_hole" */ = 12,
    LightCrack /* "light_crack" */ = 13,
    LightDint /* "light_dint" */ = 14,
    HeavySticker /* "heavy_sticker" */ = 15,
    HeavyScratch /* "heavy_scratch" */ = 16,
    HeavyHole /* "heavy_hole" */ = 17,
    HeavyCrack /* "heavy_crack" */ = 18,
    HeavyDint /* "heavy_dint" */ = 19,
    Chip /* "chip" */ = 20,


    Undefined /* "undefined" */ = 10000
};

enum class EDamageArea : ui32 {
    Exterior /* "exterior" */ = 0,
    Interior /* "interior" */ = 1,
    Glass /* "glass" */ = 2
};

inline TString UnknownCarDamageDescription = "unknown";

class TCarDamage {
private:
    R_READONLY(TString, Description, UnknownCarDamageDescription);
    R_READONLY(TString, Element);
    R_READONLY(EDamageLevel, Level, EDamageLevel::Undefined);
    R_READONLY(EDamageArea, Area, EDamageArea::Exterior);
    R_FIELD(bool, Discarded, false);
    R_FIELD(bool, IsTheBest, false);

public:
    NJson::TJsonValue BuildReport() const;

    bool ParseFromJson(const NJson::TJsonValue& report, TMessagesCollector& errors);
    bool ParseFromProto(const NDrive::NProto::TCommonImageMeta::TDamageInfo& proto);
    void SerializeToProto(NDrive::NProto::TCommonImageMeta::TDamageInfo& proto) const;
};
