#include "config.h"

namespace NDrive {
    void TIncidentsManagerConfig::Init(const TYandexConfig::Section* section) {
        auto children = section->GetAllChildren();
        {
            auto it = children.find("HistoryConfig");
            if (it != children.end()) {
                HistoryConfig.Init(it->second);
            }
        }
    }

    void TIncidentsManagerConfig::ToString(IOutputStream& os) const {
        os << "<HistoryConfig>" << Endl;
        HistoryConfig.ToString(os);
        os << "</HistoryConfig>" << Endl;
    }
}
