#pragma once

#include <util/generic/string.h>

namespace NDrive {
    static const TString GenericIncidentSettingPrefix = "incident.common";
    static const TString EvacuationSettingPrefix = "incident.evacuation";
    static const TString IncidentTransitionsSettingPrefix = "incident.transitions";
    static const TString AvarcomTransitionsSettingPrefix = "incident.avarcom";

    enum class EIncidentType {
        RoadAccident /* "road_accident" */,
        AccountTheft /* "account_theft" */,
        CarTheftDuringRide /* "car_theft_during_ride" */,
        DriveTransfer /* "drive_transfer" */,
        AccountTransfer /* "account_transfer" */,
        DrunkDriver /* "drunk_driver" */,
        Incident /* "incident" */,
        Evacuation /* "evacuation" */,
    };

    enum class EIncidentStatus {
        Undefined /* "undefined" */,

        New /* "new" */,

        StartrekTicketsProcessed /* "st_tickets_processed" */,
        StartrekTicketsProcessingError /* "st_tickets_processing_error" */,

        ObjectTagsProcessed /* "tags_processed" */,
        ObjectTagsProcessingError /* "tags_processing_error" */,

        KaskoClaimApplied /* "kasko_claim_applied" */,
        KaskoClaimApplyError /* "kasko_claim_apply_error" */,

        Closed /* "closed" */,
        Discarded /* "discarded" */,
    };

    static constexpr EIncidentStatus TerminalStatuses[] = { EIncidentStatus::Closed, EIncidentStatus::Discarded };

    enum class EIncidentContextType {
        EvacuationTicket /* "evacuation_ticket" */,
        IncidentTicket /* "incident_ticket" */,
        ReninsKaskoClaim /* "renins_kasko_claim" */,
    };

    enum class EIncidentLinkType {
        Undefined /* "undefined" */,

        Document /* "document" */,
        Photo /* "photo" */,
        UserDocumentPhoto /* "user_document_photo" */,

        Tag /* "tag" */,

        StartrekTicket /* "startrek_ticket" */,
    };

    enum class EIncidentTransition {
        UpdateData /* "update_data" */,
        UpdateDataComposite /* "update_data_composite" */,

        MakeEvacuationTicket /* "make_evacuation_ticket" */,
        MakeIncidentTicket /* "make_incident_ticket" */,
        UpdateTicketComposite /* "update_ticket_composite" */,

        HandleEvacuationObjectTags /* "handle_evacuation_object_tags" */,
        HandleIncidentObjectTags /* "handle_incident_object_tags" */,

        FetchRelatedDocuments /* "fetch_related_documents" */,

        HandleAttachedPhotos /* "handle_attached_photos" */,

        ApplyReninsKaskoClaim /* "apply_renins_kasko_claim" */,
        FetchReninsKaskoDefaults /* "fetch_renins_kasko_defaults" */,
        FillReninsKaskoClaim /* "fill_renins_kasko_claim" */,

        UpdateReninsClaimDocs /* "update_renins_claim_docs" */,

        Reopen /* "reopen" */,
        Close /* "close" */,
        Discard /* "discard" */,

        HandleAvarcomReninsTags /* "handle_avarcom_renins_tags" */,
        HandleAvarcomIngosTags /* "handle_avarcom_ingos_tags" */,
    };

    // EIncidentType without Evacuation
    enum class EIncidentFormType {
        RoadAccident /* "road_accident" */,
        AccountTheft /* "account_theft" */,
        CarTheftDuringRide /* "car_theft_during_ride" */,
        DriveTransfer /* "drive_transfer" */,
        AccountTransfer /* "account_transfer" */,
        DrunkDriver /* "drunk_driver" */,
        Incident /* "incident" */,
    };

    enum class EIncidentInjuredPersonsPresence {
        Present /* "present" */,
        Absent /* "absent" */,
    };

    enum class EIncidentInjuredPersonsLocation {
        InsideOurCar /* "inside_our_car" */,
        OutsideOurCar /* "outside_our_car" */,
    };

    enum class EIncidentCarState {
        EvacuationRequired /* "evacuation_required" */,
        DrivingPossible /* "driving_possible" */,
    };

    enum class EIncidentRegistration {
        Unavailable /* "unavailable" */,
        Pending /* "pending" */,
        Done /* "done" */,
        Unknown /* "unknown" */,
    };

    enum class EIncidentPoliceRequest {
        AgreeToInvoke /* "agree_to_invoke" */,
        RefusedToInvoke /* "refused_to_invoke" */,
        AskedToInvoke /* "asked_to_invoke" */,
    };

    enum class EIncidentPhotoSendingIntent {
        SendToChat /* "send_to_chat" */,
        SendToOS /* "send_to_os" */,
    };

    enum class EIncidentReporter {
        User /* "user" */,
        Other /* "other" */,
    };

    enum class EIncidentOriginator {
        User /* "user" */,
        ExternalUser /* "external_user" */,
        Unknown /* "unknown" */,
    };

    enum class EIncidentDamageDegree {
        High /* "high" */,
        Medium /* "medium" */,
        Absent /* "absent" */,
        Unknown /* "unknown" */,
    };

    enum class EIncidentProtocolPresence {
        Present /* "present" */,
        LeftInCar /* "left_in_car" */,
        Absent /* "absent" */,
        Unknown /* "unknown" */,
    };

    enum class EAttachedPhotosHandlingAction {
        Upsert /* "upsert" */,
        Remove /* "remove" */,
    };
}
